/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.folia;

import io.fairyproject.bukkit.scheduler.folia.FoliaAbstractScheduler;
import io.fairyproject.bukkit.scheduler.folia.FoliaRepeatedScheduledTask;
import io.fairyproject.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import io.fairyproject.mc.scheduler.MCTickBasedScheduler;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaEntityScheduler
extends FoliaAbstractScheduler
implements MCTickBasedScheduler {
    private static Method isOwnedByCurrentRegion;
    private final Entity entity;
    private final Plugin bukkitPlugin;

    @Override
    public boolean isCurrentThread() {
        if (isOwnedByCurrentRegion == null) {
            try {
                isOwnedByCurrentRegion = Bukkit.class.getMethod("isOwnedByCurrentRegion", Entity.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find isOwnedByCurrentRegion method in Bukkit", e);
            }
        }
        try {
            return (Boolean)isOwnedByCurrentRegion.invoke(null, this.entity);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot invoke isOwnedByCurrentRegion method in Bukkit", e);
        }
    }

    private EntityScheduler getEntityScheduler() {
        return this.entity.getScheduler();
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> this.getEntityScheduler().run(this.bukkitPlugin, task, null));
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.doSchedule(callable, task -> this.getEntityScheduler().runDelayed(this.bukkitPlugin, task, null, delayTicks));
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        FoliaRepeatedScheduledTask<R> task = new FoliaRepeatedScheduledTask<R>(callback, predicate);
        ScheduledTask scheduledTask = this.getEntityScheduler().runAtFixedRate(this.bukkitPlugin, task, null, delayTicks, intervalTicks);
        task.setScheduledTask(WrapperScheduledTask.of(scheduledTask));
        return task;
    }

    public FoliaEntityScheduler(Entity entity, Plugin bukkitPlugin) {
        this.entity = entity;
        this.bukkitPlugin = bukkitPlugin;
    }
}

