/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.timer;

import com.google.common.collect.Sets;
import io.fairyproject.bukkit.FairyBukkitPlatform;
import io.fairyproject.bukkit.listener.events.Events;
import io.fairyproject.bukkit.metadata.Metadata;
import io.fairyproject.bukkit.timer.Timer;
import io.fairyproject.bukkit.timer.TimerList;
import io.fairyproject.bukkit.timer.event.TimerClearEvent;
import io.fairyproject.bukkit.timer.impl.PlayerTimer;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.log.Log;
import io.fairyproject.mc.scheduler.MCSchedulerProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

@InjectableComponent
public class TimerService {
    private final MCSchedulerProvider mcSchedulerProvider;
    private Set<Timer> timers;
    private ReentrantLock lock;

    @PostInitialize
    public void onPostInitialize() {
        this.lock = new ReentrantLock();
        this.timers = Sets.newConcurrentHashSet();
        this.startScheduler();
        Events.subscribe(PlayerQuitEvent.class).listen(event -> Metadata.provideForPlayer(event.getPlayer()).ifPresent(PlayerTimer.TIMER_METADATA_KEY, TimerList::clear)).build((Plugin)FairyBukkitPlatform.PLUGIN);
    }

    protected void add(Timer timer) {
        this.lock.lock();
        this.timers.add(timer);
        this.lock.unlock();
    }

    protected void clear(Timer timer) {
        this.lock.lock();
        this.timers.remove(timer);
        this.lock.unlock();
    }

    public void clearByTimerClass(Class<? extends Timer> timerClass) {
        this.lock.lock();
        this.timers.removeIf(timer -> timerClass.isInstance(timer) && timer.clear());
        this.lock.unlock();
    }

    public void startScheduler() {
        this.mcSchedulerProvider.getGlobalScheduler().scheduleAtFixedRate(() -> {
            this.lock.lock();
            Iterator<Timer> iterator = this.timers.iterator();
            while (iterator.hasNext()) {
                Timer timer = iterator.next();
                try {
                    if (timer.isPaused()) continue;
                    timer.tick();
                    if (!timer.isElapsed() || !timer.elapsed() || !timer.clear(false, TimerClearEvent.Reason.ELAPSED)) continue;
                    iterator.remove();
                }
                catch (Exception e) {
                    Log.error("Error occurred while ticking timer " + timer.getClass().getSimpleName() + "!", e, new Object[0]);
                    timer.clear();
                }
            }
            this.lock.unlock();
        }, 2L, 2L);
    }

    public boolean isTimerRunning(Class<? extends Timer> timerClass) {
        return this.getTimer(timerClass) != null;
    }

    public <T extends Timer> T getTimer(Class<T> timerClass) {
        Timer ret;
        this.lock.lock();
        try {
            ret = (Timer)timerClass.cast(this.timers.stream().filter(timerClass::isInstance).findFirst().orElse(null));
        }
        finally {
            this.lock.unlock();
        }
        return (T)ret;
    }

    public TimerService(MCSchedulerProvider mcSchedulerProvider) {
        this.mcSchedulerProvider = mcSchedulerProvider;
    }
}

