/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.items;

import io.fairyproject.bukkit.FairyBukkitPlatform;
import io.fairyproject.bukkit.listener.events.Events;
import io.fairyproject.bukkit.nbt.NBTKey;
import io.fairyproject.bukkit.nbt.NBTModifier;
import io.fairyproject.bukkit.util.items.FairyItem;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.util.ConditionUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@InjectableComponent
public class FairyItemRegistry {
    private final NBTKey itemNbtKey = NBTKey.create("fairy", "item", "name");
    private final Map<String, FairyItem> itemByName = new ConcurrentHashMap<String, FairyItem>();
    private final Map<Plugin, List<FairyItem>> itemsByPlugin = new ConcurrentHashMap<Plugin, List<FairyItem>>();
    private final NBTModifier nbtModifier;

    public FairyItemRegistry(NBTModifier nbtModifier) {
        this.nbtModifier = nbtModifier;
    }

    @PostInitialize
    public void onPostInitialize() {
        Events.subscribe(PluginDisableEvent.class).filter(event -> this.itemsByPlugin.containsKey(event.getPlugin())).listen(event -> {
            List<FairyItem> items = this.itemsByPlugin.remove(event.getPlugin());
            items.forEach(item -> this.itemByName.remove(item.getName()));
        }).build((Plugin)FairyBukkitPlatform.PLUGIN);
    }

    public boolean has(String name) {
        return this.itemByName.containsKey(name);
    }

    public void register(FairyItem item) {
        ConditionUtils.not(this.itemByName.containsKey(item.getName()), "Item with id " + item.getName() + " already exists");
        ConditionUtils.is(item.isClosed(), "Item is already registered");
        this.itemByName.put(item.getName(), item);
        item.init();
    }

    public void unregister(FairyItem item) {
        ConditionUtils.is(this.itemByName.containsKey(item.getName()), "Item with id " + item.getName() + " does not exist");
        ConditionUtils.not(item.isClosed(), "Item is already closed");
        this.itemByName.remove(item.getName());
        item.closeAndReportException();
    }

    public FairyItem get(String id) {
        return this.itemByName.get(id);
    }

    public FairyItem get(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        String key = this.nbtModifier.getString(itemStack, this.itemNbtKey);
        return key == null ? null : this.get(key);
    }

    public ItemStack set(@NotNull ItemStack itemStack, @NotNull FairyItem fairyItem) {
        return this.nbtModifier.setTag(itemStack, this.itemNbtKey, fairyItem.getName());
    }
}

