/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.items;

import io.fairyproject.bukkit.nbt.NBTKey;
import io.fairyproject.bukkit.util.items.impl.ItemBuilderImpl;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.xseries.XEnchantment;
import io.fairyproject.libs.xseries.XMaterial;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;

public interface ItemBuilder
extends Cloneable {
    public static ItemBuilder of(XMaterial material) {
        return new ItemBuilderImpl(material);
    }

    public static ItemBuilder of(Material material) {
        return new ItemBuilderImpl(XMaterial.matchXMaterial(material));
    }

    public static ItemBuilder of(ItemStack itemStack) {
        return new ItemBuilderImpl(itemStack);
    }

    @Contract(value="_ -> this")
    default public ItemBuilder name(Component component) {
        return this.name(Locale.ENGLISH, component);
    }

    @Contract(value="_ -> this")
    default public ItemBuilder lores(Component ... components) {
        return this.lores(Locale.ENGLISH, components);
    }

    @Contract(value="_ -> this")
    default public ItemBuilder lores(Iterable<Component> component) {
        return this.lores(Locale.ENGLISH, component);
    }

    @Contract(value="_, _ -> this")
    public ItemBuilder name(Locale var1, Component var2);

    @Contract(value="_, _ -> this")
    public ItemBuilder lores(Locale var1, Iterable<Component> var2);

    @Contract(value="_, _ -> this")
    public ItemBuilder lores(Locale var1, Component ... var2);

    @Contract(value="_ -> this")
    public ItemBuilder name(String var1);

    @Contract(value="_ -> this")
    public ItemBuilder lore(Iterable<String> var1);

    @Contract(value="_ -> this")
    public ItemBuilder lore(String ... var1);

    @Contract(value="_ -> this")
    public ItemBuilder amount(int var1);

    @Contract(value="_ -> this")
    public ItemBuilder unbreakable(boolean var1);

    @Contract(value="_ -> this")
    public ItemBuilder durability(int var1);

    @Contract(value="_ -> this")
    public ItemBuilder data(int var1);

    @Contract(value="_, _ -> this")
    public ItemBuilder enchantment(XEnchantment var1, int var2);

    @Contract(value="_ -> this")
    public ItemBuilder enchantment(XEnchantment var1);

    @Contract(value="_ -> this")
    public ItemBuilder type(XMaterial var1);

    @Contract(value=" -> this")
    public ItemBuilder clearLore();

    @Contract(value=" -> this")
    public ItemBuilder clearEnchantments();

    @Contract(value="_ -> this")
    public ItemBuilder color(Color var1);

    @Contract(value="_ -> this")
    public ItemBuilder skull(String var1);

    @Contract(value="_ -> this")
    public ItemBuilder skull(Player var1);

    @Contract(value=" -> this")
    public ItemBuilder shiny();

    @Deprecated
    @Contract(value="_, _ -> this")
    public ItemBuilder tag(Object var1, String ... var2);

    @Contract(value="_, _ -> this")
    public ItemBuilder tag(NBTKey var1, Object var2);

    @Contract(value="_ -> this")
    public ItemBuilder itemFlag(ItemFlag var1);

    @Contract(value="_ -> this")
    public ItemBuilder removeItemFlag(ItemFlag var1);

    @Contract(value="_ -> this")
    public ItemBuilder editMeta(Consumer<ItemMeta> var1);

    @Contract(value="_, _ -> this")
    public <T extends ItemMeta> ItemBuilder editMeta(Class<T> var1, Consumer<T> var2);

    @Contract(value="_ -> this")
    public ItemBuilder editItemStack(Consumer<ItemStack> var1);

    @Contract(value="_ -> this")
    public ItemBuilder transformMeta(Function<ItemMeta, ItemMeta> var1);

    @Contract(value="_, _ -> this")
    public <T extends ItemMeta> ItemBuilder transformMeta(Class<T> var1, Function<T, T> var2);

    @Contract(value="_ -> this")
    public ItemBuilder transformItemStack(Function<ItemStack, ItemStack> var1);

    @Contract(value=" -> new")
    public ItemStack build();

    public Material getType();

    public ItemBuilder clone();
}

