/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.schematic.impl;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.registry.WorldData;
import io.fairyproject.bukkit.util.schematic.Schematic;
import io.fairyproject.mc.util.BlockPosition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Location;

public class WorldEditSchematic
extends Schematic {
    public WorldEditSchematic(File file) {
        super(file);
    }

    public WorldEditSchematic(File file, BlockPosition top, BlockPosition bottom) {
        super(file, top, bottom);
    }

    @Override
    public void save(org.bukkit.World world) throws IOException {
        Preconditions.checkNotNull((Object)this.file);
        Preconditions.checkNotNull((Object)this.top);
        Preconditions.checkNotNull((Object)this.bottom);
        Vector top = new Vector(this.top.getX(), this.top.getY(), this.top.getZ());
        Vector bottom = new Vector(this.bottom.getX(), this.bottom.getY(), this.bottom.getZ());
        CuboidRegion region = new CuboidRegion((LocalWorld)new BukkitWorld(world), top, bottom);
        BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
        try (ClipboardWriter writer = ClipboardFormat.SCHEMATIC.getWriter((OutputStream)new FileOutputStream(this.file));){
            writer.write((Clipboard)clipboard, new BukkitWorld(world).getWorldData());
        }
    }

    @Override
    public void paste(Location location, int rotateX, int rotateY, int rotateZ) throws IOException {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)this.file);
        Vector vector = new Vector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BukkitWorld world = new BukkitWorld(location.getWorld());
        WorldData worldData = world.getWorldData();
        Clipboard clipboard = ClipboardFormat.SCHEMATIC.getReader((InputStream)new FileInputStream(this.file)).read(worldData);
        Region region = clipboard.getRegion();
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)world, -1);
        AffineTransform transform = new AffineTransform();
        if (rotateX != 0) {
            transform = transform.rotateX((double)rotateX);
        }
        if (rotateY != 0) {
            transform = transform.rotateY((double)rotateY);
        }
        if (rotateZ != 0) {
            transform = transform.rotateZ((double)rotateZ);
        }
        ForwardExtentCopy copy = new ForwardExtentCopy((Extent)clipboard, region, clipboard.getOrigin(), (Extent)editSession, vector);
        if (!transform.isIdentity()) {
            copy.setTransform((Transform)transform);
        }
        Vector top = region.getMaximumPoint();
        Vector bottom = region.getMinimumPoint();
        this.top = new BlockPosition(top.getBlockX(), top.getBlockY(), top.getBlockZ());
        this.bottom = new BlockPosition(bottom.getBlockX(), bottom.getBlockY(), bottom.getBlockZ());
        try {
            Operations.completeLegacy((Operation)copy);
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
        editSession.flushQueue();
    }
}

