/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.visual.sender.impl;

import io.fairyproject.Debug;
import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.resolver.MethodResolver;
import io.fairyproject.bukkit.reflection.wrapper.MethodWrapper;
import io.fairyproject.bukkit.visual.sender.VisualData;
import io.fairyproject.libs.xseries.XMaterial;
import org.bukkit.Material;

public class NewVisualData
implements VisualData {
    private final Class<?> magicNumbersClass;
    private final MethodWrapper<?> fromLegacyDataMethod;
    private final MethodWrapper<?> getIdMethod;

    public NewVisualData(BukkitNMSManager nmsManager) {
        Class magicNumbers = null;
        MethodWrapper fromLegacyData = null;
        MethodWrapper getId = null;
        try {
            if (nmsManager.isSupported()) {
                Class blockStateType = nmsManager.getNmsClassResolver().resolve("world.level.block.state.BlockState", "IBlockData");
                Class blockType = nmsManager.getNmsClassResolver().resolve("world.level.block.Block", "Block");
                magicNumbers = nmsManager.getObcClassResolver().resolve("util.CraftMagicNumbers");
                fromLegacyData = new MethodResolver(magicNumbers).resolve(blockStateType, 0, Material.class, Byte.TYPE);
                getId = new MethodResolver(blockType).resolve(blockStateType, 0, blockType);
                Debug.log("Initialized NewData for Visual module.", new Object[0]);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        this.magicNumbersClass = magicNumbers;
        this.fromLegacyDataMethod = fromLegacyData;
        this.getIdMethod = getId;
    }

    @Override
    public int getId(XMaterial material) {
        Object blockState = this.fromLegacyDataMethod.invoke(null, material.parseMaterial(), material.getData());
        Object invoke = this.getIdMethod.invoke(null, blockState);
        return (Integer)invoke;
    }

    @Override
    public boolean isCapable() {
        return this.magicNumbersClass != null && this.fromLegacyDataMethod != null && this.getIdMethod != null;
    }
}

