/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command.argument;

import io.fairyproject.command.CommandContext;
import io.fairyproject.command.parameter.ArgTransformer;
import java.util.Objects;
import java.util.function.Consumer;

public class ArgProperty<T> {
    private final String key;
    private final Class<T> type;
    private Consumer<CommandContext> missingArgument;
    private UnknownArgumentHandler unknownArgument;
    private ArgTransformer<T> parameterHolder;

    public static <T> ArgProperty<T> create(String key, Class<T> type) {
        return new ArgProperty<T>(key, type);
    }

    public ArgProperty<T> onMissingArgument(Consumer<CommandContext> missingArgument) {
        this.missingArgument = missingArgument;
        return this;
    }

    public ArgProperty<T> onUnknownArgument(UnknownArgumentHandler unknownArgument) {
        this.unknownArgument = unknownArgument;
        return this;
    }

    public ArgProperty<T> parameterHolder(ArgTransformer<T> parameterHolder) {
        this.parameterHolder = parameterHolder;
        return this;
    }

    public T cast(Object object) {
        return this.type.cast(object);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgProperty that = (ArgProperty)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    private ArgProperty(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Consumer<CommandContext> getMissingArgument() {
        return this.missingArgument;
    }

    public UnknownArgumentHandler getUnknownArgument() {
        return this.unknownArgument;
    }

    public ArgTransformer<T> getParameterHolder() {
        return this.parameterHolder;
    }

    public static interface UnknownArgumentHandler {
        public void accept(CommandContext var1, String var2, String var3);
    }
}

