/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command.parameter.impl;

import io.fairyproject.command.CommandContext;
import io.fairyproject.command.parameter.ArgTransformer;
import io.fairyproject.container.object.Obj;
import java.util.HashMap;
import java.util.Map;

@Obj
public class BooleanArgTransformer
implements ArgTransformer<Boolean> {
    private static final Map<String, Boolean> MAP = new HashMap<String, Boolean>();

    @Override
    public Class[] type() {
        return new Class[]{Boolean.class, Boolean.TYPE};
    }

    @Override
    public Boolean transform(CommandContext event, String source) {
        if (!MAP.containsKey(source.toLowerCase())) {
            return (Boolean)this.fail(source + " is not a valid boolean.");
        }
        return MAP.get(source.toLowerCase());
    }

    static {
        MAP.put("true", true);
        MAP.put("on", true);
        MAP.put("yes", true);
        MAP.put("false", false);
        MAP.put("off", false);
        MAP.put("no", false);
    }
}

