/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container;

import io.fairyproject.Debug;
import io.fairyproject.Fairy;
import io.fairyproject.container.ClasspathScan;
import io.fairyproject.container.ContainerNodePluginListener;
import io.fairyproject.container.RootNodeLoader;
import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.binder.ContainerObjectBinderImpl;
import io.fairyproject.container.collection.ContainerObjCollectorRegistry;
import io.fairyproject.container.node.ContainerNode;
import io.fairyproject.container.node.destroyer.ContainerNodeDestroyer;
import io.fairyproject.container.node.loader.ContainerNodeLoader;
import io.fairyproject.container.object.singleton.SingletonObjectRegistry;
import io.fairyproject.container.processor.ContainerNodeClassScanProcessor;
import io.fairyproject.container.processor.ContainerNodeInitProcessor;
import io.fairyproject.container.processor.ContainerObjConstructProcessor;
import io.fairyproject.container.processor.ContainerObjDestroyProcessor;
import io.fairyproject.container.processor.ContainerObjInitProcessor;
import io.fairyproject.container.processor.ContainerProcessors;
import io.fairyproject.container.processor.annotation.FairyLifeCycleAnnotationProcessor;
import io.fairyproject.container.processor.injection.AutowiredAnnotationProcessor;
import io.fairyproject.container.processor.injection.SubscribeEventAnnotationProcessor;
import io.fairyproject.event.GlobalEventNode;
import io.fairyproject.event.impl.PostServiceInitialEvent;
import io.fairyproject.log.Log;
import io.fairyproject.plugin.PluginManager;
import io.fairyproject.util.thread.NamedThreadFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ContainerContext
implements ContainerProcessors {
    @Deprecated
    private static ContainerContext INSTANCE;
    public static final int PLUGIN_LISTENER_PRIORITY = 100;
    public final ExecutorService executor = Executors.newCachedThreadPool(NamedThreadFactory.builder().name("Container Thread - %d").daemon(true).uncaughtExceptionHandler((thread, throwable) -> Log.error("Exception occurred in Container Thread", throwable, new Object[0])).build());
    private final ContainerObjCollectorRegistry objectCollectorRegistry;
    private final ContainerObjectBinder containerObjectBinder = new ContainerObjectBinderImpl();
    private final SingletonObjectRegistry singletonObjectRegistry;
    private final ContainerNodeDestroyer nodeDestroyer;
    private final ContainerObjConstructProcessor[] constructProcessors;
    private final ContainerObjInitProcessor[] initProcessors;
    private final ContainerObjDestroyProcessor[] destroyProcessors;
    private final ContainerNodeClassScanProcessor[] nodeClassScanProcessors;
    private final ContainerNodeInitProcessor[] nodeInitProcessors;
    private ContainerNode node;

    public ContainerContext() {
        this.objectCollectorRegistry = new ContainerObjCollectorRegistry();
        this.singletonObjectRegistry = SingletonObjectRegistry.create();
        this.nodeDestroyer = new ContainerNodeDestroyer(this);
        FairyLifeCycleAnnotationProcessor annotationProcessor = new FairyLifeCycleAnnotationProcessor();
        AutowiredAnnotationProcessor autowiredAnnotationProcessor = new AutowiredAnnotationProcessor();
        SubscribeEventAnnotationProcessor subscribeEventAnnotationProcessor = new SubscribeEventAnnotationProcessor();
        this.constructProcessors = new ContainerObjConstructProcessor[0];
        this.initProcessors = new ContainerObjInitProcessor[]{autowiredAnnotationProcessor, subscribeEventAnnotationProcessor, annotationProcessor};
        this.destroyProcessors = new ContainerObjDestroyProcessor[]{annotationProcessor, subscribeEventAnnotationProcessor};
        this.nodeClassScanProcessors = new ContainerNodeClassScanProcessor[]{autowiredAnnotationProcessor};
        this.nodeInitProcessors = new ContainerNodeInitProcessor[]{autowiredAnnotationProcessor};
    }

    public void init() {
        INSTANCE = this;
        this.node = new RootNodeLoader(this).load();
        if (PluginManager.isInitialized()) {
            Debug.log("Find PluginManager, attempt to register Plugin Listeners", new Object[0]);
            PluginManager.INSTANCE.registerListener(new ContainerNodePluginListener(this));
        }
        Fairy.getPlatform().onPostServicesInitial();
        GlobalEventNode.get().call(new PostServiceInitialEvent());
    }

    public void stop() {
        try {
            if (this.node != null) {
                this.nodeDestroyer.destroy(this.node);
            }
        }
        finally {
            INSTANCE = null;
        }
    }

    public boolean isObject(Class<?> objectClass) {
        return this.containerObjectBinder.isBound(objectClass);
    }

    public boolean isObject(Object object) {
        return this.isObject(object.getClass());
    }

    public Object getSingleton(Class<?> objectClass) {
        return this.singletonObjectRegistry.getSingleton(objectClass);
    }

    public List<String> findClassPaths(Class<?> plugin) {
        ClasspathScan annotation = plugin.getAnnotation(ClasspathScan.class);
        if (annotation != null) {
            return Arrays.asList(annotation.value());
        }
        return Collections.emptyList();
    }

    public boolean loadContainerNode(ContainerNode node) {
        return new ContainerNodeLoader(this, node).load();
    }

    @Deprecated
    public static ContainerContext get() {
        return INSTANCE;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public ContainerObjCollectorRegistry objectCollectorRegistry() {
        return this.objectCollectorRegistry;
    }

    public ContainerObjectBinder containerObjectBinder() {
        return this.containerObjectBinder;
    }

    public SingletonObjectRegistry singletonObjectRegistry() {
        return this.singletonObjectRegistry;
    }

    public ContainerNodeDestroyer nodeDestroyer() {
        return this.nodeDestroyer;
    }

    @Override
    public ContainerObjConstructProcessor[] constructProcessors() {
        return this.constructProcessors;
    }

    @Override
    public ContainerObjInitProcessor[] initProcessors() {
        return this.initProcessors;
    }

    @Override
    public ContainerObjDestroyProcessor[] destroyProcessors() {
        return this.destroyProcessors;
    }

    @Override
    public ContainerNodeClassScanProcessor[] nodeClassScanProcessors() {
        return this.nodeClassScanProcessors;
    }

    @Override
    public ContainerNodeInitProcessor[] nodeInitProcessors() {
        return this.nodeInitProcessors;
    }

    public ContainerNode node() {
        return this.node;
    }
}

