/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container;

import io.fairyproject.Debug;
import io.fairyproject.Fairy;
import io.fairyproject.FairyPlatform;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.node.ContainerNode;
import io.fairyproject.container.node.scanner.ContainerNodeClassScanner;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.log.Log;
import io.fairyproject.util.Stacktrace;

public class RootNodeLoader {
    private final ContainerContext context;
    private ContainerNode node;

    public ContainerNode load() {
        this.node = ContainerNode.create("root", this.context.containerObjectBinder());
        this.addPreDefinedComponents();
        this.runClassScanner();
        this.loadNode();
        return this.node;
    }

    private boolean loadNode() {
        return this.context.loadContainerNode(this.node);
    }

    private void runClassScanner() {
        try {
            ContainerNodeClassScanner classScanner = new ContainerNodeClassScanner(this.context, this.context.containerObjectBinder(), "framework", this.node);
            classScanner.getClassPaths().add(Fairy.getFairyPackage());
            if (!Debug.UNIT_TEST) {
                classScanner.getUrls().add(this.getClass().getProtectionDomain().getCodeSource().getLocation());
                classScanner.getClassLoaders().add(ContainerContext.class.getClassLoader());
            }
            classScanner.scan();
        }
        catch (Throwable throwable) {
            Log.error("Error while scanning classes for framework", Stacktrace.simplifyStacktrace(throwable), new Object[0]);
            Fairy.getPlatform().shutdown();
        }
    }

    private void addPreDefinedComponents() {
        ContainerObj obj = ContainerObj.create(this.context.getClass());
        this.node.addObj(obj);
        this.context.containerObjectBinder().bind(ContainerContext.class, obj);
        this.context.singletonObjectRegistry().registerSingleton(ContainerContext.class, this.context);
        Debug.log("ContainerContext has been registered as ContainerObject.", new Object[0]);
        obj = ContainerObj.create(FairyPlatform.class);
        this.node.addObj(obj);
        this.context.containerObjectBinder().bind(FairyPlatform.class, obj);
        this.context.singletonObjectRegistry().registerSingleton(FairyPlatform.class, Fairy.getPlatform());
        Debug.log("FairyPlatform has been registered as ContainerObject.", new Object[0]);
    }

    public RootNodeLoader(ContainerContext context) {
        this.context = context;
    }
}

