/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.collection;

import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.container.object.ContainerObj;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ContainerObjCollectorImpl
implements ContainerObjCollector {
    private final Set<ContainerObj> objs = new CopyOnWriteArraySet<ContainerObj>();
    private final Set<Predicate<ContainerObj>> predicates = new HashSet<Predicate<ContainerObj>>();
    private final Set<Consumer<ContainerObj>> addHandlers = new HashSet<Consumer<ContainerObj>>();
    private final Set<Consumer<ContainerObj>> removeHandlers = new HashSet<Consumer<ContainerObj>>();

    @Override
    public ContainerObjCollector withFilter(@NotNull Predicate<ContainerObj> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    @Override
    public ContainerObjCollector withAddHandler(@NotNull Consumer<ContainerObj> consumer) {
        this.addHandlers.add(consumer);
        return this;
    }

    @Override
    public ContainerObjCollector withRemoveHandler(@NotNull Consumer<ContainerObj> consumer) {
        this.removeHandlers.add(consumer);
        return this;
    }

    @Override
    public void add(@NotNull ContainerObj containerObj) {
        this.objs.add(containerObj);
        this.addHandlers.forEach(consumer -> consumer.accept(containerObj));
    }

    @Override
    public boolean remove(@NotNull ContainerObj containerObj) {
        if (this.objs.remove(containerObj)) {
            this.removeHandlers.forEach(consumer -> consumer.accept(containerObj));
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<ContainerObj> all() {
        return Collections.unmodifiableSet(this.objs);
    }

    @Override
    @NotNull
    public Iterator<ContainerObj> iterator() {
        return this.objs.iterator();
    }

    @Override
    public boolean test(ContainerObj containerObj) {
        for (Predicate<ContainerObj> predicate : this.predicates) {
            if (predicate.test(containerObj)) continue;
            return false;
        }
        return true;
    }
}

