/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.collection;

import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.container.object.ContainerObj;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public class ContainerObjCollectorRegistry {
    private final Set<ContainerObjCollector> collectors = new CopyOnWriteArraySet<ContainerObjCollector>();

    public void add(@NotNull ContainerObjCollector collector) {
        this.collectors.add(collector);
    }

    public boolean remove(@NotNull ContainerObjCollector collector) {
        return this.collectors.remove(collector);
    }

    public void addToCollectors(@NotNull ContainerObj obj) {
        this.collectors.stream().filter(collector -> collector.test(obj)).forEach(collector -> collector.add(obj));
    }

    public void removeFromCollectors(@NotNull ContainerObj obj) {
        this.collectors.forEach(collector -> collector.remove(obj));
    }
}

