/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.node;

import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.node.ContainerNodeImpl;
import io.fairyproject.container.node.Graph;
import io.fairyproject.container.object.ContainerObj;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ContainerNode {
    public static ContainerNode create(String name, ContainerObjectBinder binder) {
        return new ContainerNodeImpl(name, binder);
    }

    @NotNull
    public String name();

    @Contract(value="_ -> this")
    @NotNull
    public ContainerNode addObj(@NotNull ContainerObj var1);

    @Nullable
    public ContainerObj getObj(@NotNull Class<?> var1);

    @Contract(value="_ -> this")
    @NotNull
    public ContainerNode addChild(@NotNull ContainerNode var1);

    @Contract(value="_ -> this")
    @NotNull
    public ContainerNode removeChild(@NotNull ContainerNode var1);

    @NotNull
    public Set<ContainerNode> childs();

    @NotNull
    public Set<ContainerObj> all();

    @NotNull
    public Graph<ContainerObj> graph();

    @Contract(value="-> this")
    @NotNull
    public ContainerNode resolve();

    public boolean isResolved();

    public CompletableFuture<?> forEachClockwiseAwait(Function<ContainerObj, CompletableFuture<?>> var1);

    public CompletableFuture<?> forEachCounterClockwiseAwait(Function<ContainerObj, CompletableFuture<?>> var1);
}

