/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.processor.annotation;

import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.object.resolver.ContainerObjectResolver;
import io.fairyproject.container.processor.ContainerObjDestroyProcessor;
import io.fairyproject.container.processor.ContainerObjInitProcessor;
import io.fairyproject.container.processor.annotation.LifeCycleMetadata;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class LifeCycleAnnotationProcessor
implements ContainerObjInitProcessor,
ContainerObjDestroyProcessor {
    private static final int PRE_INIT = 0;
    private static final int POST_INIT = 1;
    private static final int PRE_DESTROY = 2;
    private static final int POST_DESTROY = 3;
    private final Class<? extends Annotation>[] annotations = new Class[4];
    private final Map<Class<?>, LifeCycleMetadata> metadataByType = new ConcurrentHashMap();

    public void setPreInitAnnotation(@Nullable Class<? extends Annotation> annotation) {
        this.annotations[0] = annotation;
    }

    public void setPostInitAnnotation(@Nullable Class<? extends Annotation> annotation) {
        this.annotations[1] = annotation;
    }

    public void setPreDestroyAnnotation(@Nullable Class<? extends Annotation> annotation) {
        this.annotations[2] = annotation;
    }

    public void setPostDestroyAnnotation(@Nullable Class<? extends Annotation> annotation) {
        this.annotations[3] = annotation;
    }

    private LifeCycleMetadata findOrCreateMetadata(Class<?> type) {
        return this.metadataByType.computeIfAbsent(type, t -> new LifeCycleMetadata((Class<?>)t, this.annotations));
    }

    @Override
    public CompletableFuture<?> processPreInitialization(ContainerObj object, Object instance, ContainerObjectResolver resolver) {
        return object.getThreadingMode().execute(() -> this.findOrCreateMetadata(instance.getClass()).invoke(0, instance));
    }

    @Override
    public CompletableFuture<?> processPostInitialization(ContainerObj object, Object instance) {
        return object.getThreadingMode().execute(() -> this.findOrCreateMetadata(instance.getClass()).invoke(1, instance));
    }

    @Override
    public void processPreDestroy(ContainerObj object, Object instance) {
        this.findOrCreateMetadata(instance.getClass()).invoke(2, instance);
    }

    @Override
    public void processPostDestroy(ContainerObj object, Object instance) {
        this.findOrCreateMetadata(instance.getClass()).invoke(3, instance);
    }
}

