/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.event;

import io.fairyproject.event.Event;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EventFilter<E, H> {
    public static final EventFilter<Event, ?> ALL = EventFilter.from(Event.class, null, null);

    public static <E, H> EventFilter<E, H> from(final @NotNull Class<E> eventType, final @Nullable Class<H> handlerType, final @Nullable Function<E, H> handlerGetter) {
        return new EventFilter<E, H>(){

            @Override
            @Nullable
            public H getHandler(@NotNull E event) {
                return handlerGetter != null ? (Object)handlerGetter.apply(event) : null;
            }

            @Override
            @NotNull
            public Class<E> eventType() {
                return eventType;
            }

            @Override
            @Nullable
            public Class<H> handlerType() {
                return handlerType;
            }
        };
    }

    @Nullable
    public H getHandler(@NotNull E var1);

    @ApiStatus.Internal
    @Nullable
    default public H castHandler(@NotNull Object event) {
        return this.getHandler(event);
    }

    @NotNull
    public Class<E> eventType();

    @Nullable
    public Class<H> handlerType();
}

