/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.event;

import io.fairyproject.log.Log;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class Subscriber<E>
implements Comparable<Subscriber<E>> {
    private final Class<E> type;
    private final int priority;

    public Subscriber(Class<E> type, int priority) {
        this.type = type;
        this.priority = priority;
    }

    public boolean isInstance(Object obj) {
        return false;
    }

    public abstract void invoke(E var1) throws Throwable;

    public void handleException(E event, Throwable throwable) {
        Log.error("An exception has occurs while handing event " + event.getClass(), throwable, new Object[0]);
    }

    protected final void invoke0(Object event) throws Throwable {
        this.invoke(this.type.cast(event));
    }

    protected final void handleException0(Object event, Throwable throwable) {
        this.handleException(this.type.cast(event), throwable);
    }

    @Override
    public int compareTo(@NotNull Subscriber<E> o) {
        return o.priority - this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscriber that = (Subscriber)o;
        return this.priority == that.priority && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.priority);
    }

    public Class<E> getType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }
}

