/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard;

import io.fairyproject.libs.kyori.adventure.text.format.TextDecoration;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.ClickTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.DecorationTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.FontTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.GradientTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.HoverTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.InsertionTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.KeybindTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.NbtTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.NewlineTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.PrideTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.RainbowTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.ResetTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.ScoreTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.SelectorTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.ShadowColorTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.TransitionTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.TranslatableFallbackTag;
import io.fairyproject.libs.kyori.adventure.text.minimessage.tag.standard.TranslatableTag;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class StandardTags {
    private static final TagResolver ALL = TagResolver.builder().resolvers(HoverTag.RESOLVER, ClickTag.RESOLVER, ColorTagResolver.INSTANCE, KeybindTag.RESOLVER, TranslatableTag.RESOLVER, TranslatableFallbackTag.RESOLVER, InsertionTag.RESOLVER, FontTag.RESOLVER, DecorationTag.RESOLVER, GradientTag.RESOLVER, RainbowTag.RESOLVER, ResetTag.RESOLVER, NewlineTag.RESOLVER, TransitionTag.RESOLVER, SelectorTag.RESOLVER, ScoreTag.RESOLVER, NbtTag.RESOLVER, PrideTag.RESOLVER, ShadowColorTag.RESOLVER).build();

    private StandardTags() {
    }

    @NotNull
    public static TagResolver decorations(@NotNull TextDecoration decoration) {
        return Objects.requireNonNull(DecorationTag.RESOLVERS.get(decoration), "No resolver found for decoration (this should not be possible?)");
    }

    @NotNull
    public static TagResolver decorations() {
        return DecorationTag.RESOLVER;
    }

    @NotNull
    public static TagResolver color() {
        return ColorTagResolver.INSTANCE;
    }

    @NotNull
    public static TagResolver hoverEvent() {
        return HoverTag.RESOLVER;
    }

    @NotNull
    public static TagResolver clickEvent() {
        return ClickTag.RESOLVER;
    }

    @NotNull
    public static TagResolver keybind() {
        return KeybindTag.RESOLVER;
    }

    @NotNull
    public static TagResolver translatable() {
        return TranslatableTag.RESOLVER;
    }

    @NotNull
    public static TagResolver translatableFallback() {
        return TranslatableFallbackTag.RESOLVER;
    }

    @NotNull
    public static TagResolver insertion() {
        return InsertionTag.RESOLVER;
    }

    @NotNull
    public static TagResolver font() {
        return FontTag.RESOLVER;
    }

    @NotNull
    public static TagResolver gradient() {
        return GradientTag.RESOLVER;
    }

    @NotNull
    public static TagResolver rainbow() {
        return RainbowTag.RESOLVER;
    }

    public static TagResolver transition() {
        return TransitionTag.RESOLVER;
    }

    @NotNull
    public static TagResolver reset() {
        return ResetTag.RESOLVER;
    }

    @NotNull
    public static TagResolver newline() {
        return NewlineTag.RESOLVER;
    }

    @NotNull
    public static TagResolver selector() {
        return SelectorTag.RESOLVER;
    }

    @NotNull
    public static TagResolver score() {
        return ScoreTag.RESOLVER;
    }

    @NotNull
    public static TagResolver nbt() {
        return NbtTag.RESOLVER;
    }

    @NotNull
    public static TagResolver pride() {
        return PrideTag.RESOLVER;
    }

    @NotNull
    public static TagResolver shadowColor() {
        return ShadowColorTag.RESOLVER;
    }

    @NotNull
    public static TagResolver defaults() {
        return ALL;
    }

    static Set<String> names(String ... names) {
        return new HashSet<String>(Arrays.asList(names));
    }
}

