/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.adventure.serializer.gson;

import io.fairyproject.libs.gson.Gson;
import io.fairyproject.libs.gson.JsonElement;
import io.fairyproject.libs.gson.JsonParseException;
import io.fairyproject.libs.gson.TypeAdapter;
import io.fairyproject.libs.gson.stream.JsonReader;
import io.fairyproject.libs.gson.stream.JsonToken;
import io.fairyproject.libs.gson.stream.JsonWriter;
import io.fairyproject.libs.kyori.adventure.key.Key;
import io.fairyproject.libs.kyori.adventure.nbt.api.BinaryTagHolder;
import io.fairyproject.libs.kyori.adventure.text.event.HoverEvent;
import io.fairyproject.libs.packetevents.adventure.option.OptionState;
import io.fairyproject.libs.packetevents.adventure.serializer.gson.BackwardCompatUtil;
import io.fairyproject.libs.packetevents.adventure.serializer.gson.GsonDataComponentValue;
import io.fairyproject.libs.packetevents.adventure.serializer.gson.SerializerFactory;
import io.fairyproject.libs.packetevents.adventure.serializer.json.JSONOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class ShowItemSerializer
extends TypeAdapter<HoverEvent.ShowItem> {
    private static final String LEGACY_SHOW_ITEM_TAG = "tag";
    private final Gson gson;
    private final boolean emitDefaultQuantity;
    private final JSONOptions.ShowItemHoverDataMode itemDataMode;

    static TypeAdapter<HoverEvent.ShowItem> create(Gson gson, OptionState opt) {
        return new ShowItemSerializer(gson, opt.value(JSONOptions.EMIT_DEFAULT_ITEM_HOVER_QUANTITY), opt.value(JSONOptions.SHOW_ITEM_HOVER_DATA_MODE)).nullSafe();
    }

    private ShowItemSerializer(Gson gson, boolean emitDefaultQuantity, JSONOptions.ShowItemHoverDataMode itemDataMode) {
        this.gson = gson;
        this.emitDefaultQuantity = emitDefaultQuantity;
        this.itemDataMode = itemDataMode;
    }

    @Override
    public HoverEvent.ShowItem read(JsonReader in) throws IOException {
        in.beginObject();
        Key key = null;
        int count = 1;
        BinaryTagHolder nbt = null;
        HashMap<Key, GsonDataComponentValue> dataComponents = null;
        while (in.hasNext()) {
            String fieldName = in.nextName();
            if (fieldName.equals("id")) {
                key = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (fieldName.equals("count")) {
                count = in.nextInt();
                continue;
            }
            if (fieldName.equals(LEGACY_SHOW_ITEM_TAG)) {
                JsonToken token = in.peek();
                if (token == JsonToken.STRING || token == JsonToken.NUMBER) {
                    if (BackwardCompatUtil.IS_4_10_0_OR_NEWER) {
                        nbt = BinaryTagHolder.binaryTagHolder(in.nextString());
                        continue;
                    }
                    nbt = BinaryTagHolder.of(in.nextString());
                    continue;
                }
                if (token == JsonToken.BOOLEAN) {
                    if (BackwardCompatUtil.IS_4_10_0_OR_NEWER) {
                        nbt = BinaryTagHolder.binaryTagHolder(String.valueOf(in.nextBoolean()));
                        continue;
                    }
                    nbt = BinaryTagHolder.of(String.valueOf(in.nextBoolean()));
                    continue;
                }
                if (token == JsonToken.NULL) {
                    in.nextNull();
                    continue;
                }
                throw new JsonParseException("Expected tag to be a string");
            }
            if (fieldName.equals("components")) {
                in.beginObject();
                while (in.peek() != JsonToken.END_OBJECT) {
                    Key id = Key.key(in.nextName());
                    JsonElement tree = (JsonElement)this.gson.fromJson(in, (Type)((Object)JsonElement.class));
                    if (dataComponents == null) {
                        dataComponents = new HashMap<Key, GsonDataComponentValue>();
                    }
                    dataComponents.put(id, GsonDataComponentValue.gsonDataComponentValue(tree));
                }
                in.endObject();
                continue;
            }
            in.skipValue();
        }
        if (key == null) {
            throw new JsonParseException("Not sure how to deserialize show_item hover event");
        }
        in.endObject();
        if (dataComponents != null) {
            return HoverEvent.ShowItem.showItem(key, count, dataComponents);
        }
        return BackwardCompatUtil.createShowItem(key, count, nbt);
    }

    @Override
    public void write(JsonWriter out, HoverEvent.ShowItem value) throws IOException {
        Map<Object, Object> dataComponents;
        out.beginObject();
        out.name("id");
        this.gson.toJson((Object)value.item(), SerializerFactory.KEY_TYPE, out);
        int count = value.count();
        if (count != 1 || this.emitDefaultQuantity) {
            out.name("count");
            out.value(count);
        }
        Map<Object, Object> map = dataComponents = !BackwardCompatUtil.IS_4_17_0_OR_NEWER ? Collections.emptyMap() : value.dataComponents();
        if (!dataComponents.isEmpty() && this.itemDataMode != JSONOptions.ShowItemHoverDataMode.EMIT_LEGACY_NBT) {
            out.name("components");
            out.beginObject();
            for (Map.Entry<Key, GsonDataComponentValue> entry : value.dataComponentsAs(GsonDataComponentValue.class).entrySet()) {
                out.name(entry.getKey().asString());
                this.gson.toJson(entry.getValue().element(), out);
            }
            out.endObject();
        } else if (this.itemDataMode != JSONOptions.ShowItemHoverDataMode.EMIT_DATA_COMPONENTS) {
            ShowItemSerializer.maybeWriteLegacy(out, value);
        }
        out.endObject();
    }

    private static void maybeWriteLegacy(JsonWriter out, HoverEvent.ShowItem value) throws IOException {
        @Nullable BinaryTagHolder nbt = value.nbt();
        if (nbt != null) {
            out.name(LEGACY_SHOW_ITEM_TAG);
            out.value(nbt.string());
        }
    }
}

