/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.impl.netty.factory;

import io.fairyproject.libs.packetevents.PacketEvents;
import io.fairyproject.libs.packetevents.PacketEventsAPI;
import io.fairyproject.libs.packetevents.impl.netty.BuildData;
import io.fairyproject.libs.packetevents.impl.netty.NettyManagerImpl;
import io.fairyproject.libs.packetevents.impl.netty.manager.player.PlayerManagerAbstract;
import io.fairyproject.libs.packetevents.impl.netty.manager.server.ServerManagerAbstract;
import io.fairyproject.libs.packetevents.injector.ChannelInjector;
import io.fairyproject.libs.packetevents.manager.InternalPacketListener;
import io.fairyproject.libs.packetevents.manager.player.PlayerManager;
import io.fairyproject.libs.packetevents.manager.protocol.ProtocolManager;
import io.fairyproject.libs.packetevents.manager.server.ServerManager;
import io.fairyproject.libs.packetevents.netty.NettyManager;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.settings.PacketEventsSettings;

public class NettyPacketEventsBuilder {
    private static PacketEventsAPI<BuildData> INSTANCE;

    public static void clearBuildCache() {
        INSTANCE = null;
    }

    public static PacketEventsAPI<BuildData> build(BuildData data, ChannelInjector injector, ProtocolManager protocolManager, ServerManagerAbstract serverManager, PlayerManagerAbstract playerManager) {
        if (INSTANCE == null) {
            INSTANCE = NettyPacketEventsBuilder.buildNoCache(data, injector, protocolManager, serverManager, playerManager);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<BuildData> build(BuildData data, ChannelInjector injector, ProtocolManager protocolManager, ServerManagerAbstract serverManager, PlayerManagerAbstract playerManager, PacketEventsSettings settings) {
        if (INSTANCE == null) {
            INSTANCE = NettyPacketEventsBuilder.buildNoCache(data, injector, protocolManager, serverManager, playerManager, settings);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<BuildData> buildNoCache(BuildData data, ChannelInjector injector, ProtocolManager protocolManager, ServerManagerAbstract serverManager, PlayerManagerAbstract playerManager) {
        return NettyPacketEventsBuilder.buildNoCache(data, injector, protocolManager, serverManager, playerManager, new PacketEventsSettings());
    }

    public static PacketEventsAPI<BuildData> buildNoCache(final BuildData data, final ChannelInjector injector, final ProtocolManager protocolManager, final ServerManagerAbstract serverManager, final PlayerManagerAbstract playerManager, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<BuildData>(){
            private final PacketEventsSettings settings;
            private final NettyManager nettyManager;
            private boolean loaded;
            private boolean initialized;
            private boolean terminated;
            {
                this.settings = inSettings;
                this.nettyManager = new NettyManagerImpl();
            }

            @Override
            public void load() {
                if (!this.loaded) {
                    PacketEvents.IDENTIFIER = "pe-" + data.getName().toLowerCase();
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + data.getName().toLowerCase();
                    PacketEvents.DECODER_NAME = "pe-decoder-" + data.getName().toLowerCase();
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + data.getName().toLowerCase();
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + data.getName().toLowerCase();
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + data.getName().toLowerCase();
                    injector.inject();
                    this.loaded = true;
                    this.getEventManager().registerListener(new InternalPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (!this.initialized) {
                    if (this.settings.shouldCheckForUpdates()) {
                        this.getUpdateChecker().handleUpdateCheck();
                    }
                    PacketType.Play.Client.load();
                    PacketType.Play.Server.load();
                    this.initialized = true;
                }
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    injector.uninject();
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public BuildData getPlugin() {
                return data;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return injector;
            }
        };
    }
}

