/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.advancements;

import io.fairyproject.libs.packetevents.protocol.advancements.Advancement;
import io.fairyproject.libs.packetevents.resources.ResourceLocation;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;

public final class AdvancementHolder {
    private ResourceLocation identifier;
    private Advancement advancement;

    public AdvancementHolder(ResourceLocation identifier, Advancement advancement) {
        this.identifier = identifier;
        this.advancement = advancement;
    }

    public static AdvancementHolder read(PacketWrapper<?> wrapper) {
        ResourceLocation identifier = wrapper.readIdentifier();
        Advancement advancement = Advancement.read(wrapper);
        return new AdvancementHolder(identifier, advancement);
    }

    public static void write(PacketWrapper<?> wrapper, AdvancementHolder holder) {
        wrapper.writeIdentifier(holder.identifier);
        Advancement.write(wrapper, holder.advancement);
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    public Advancement getAdvancement() {
        return this.advancement;
    }

    public void setAdvancement(Advancement advancement) {
        this.advancement = advancement;
    }
}

