/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.item.enchantment.type;

import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.packetevents.protocol.component.EnchantEffectComponentTypes;
import io.fairyproject.libs.packetevents.protocol.component.IComponentMap;
import io.fairyproject.libs.packetevents.protocol.component.StaticComponentMap;
import io.fairyproject.libs.packetevents.protocol.item.enchantment.EnchantmentDefinition;
import io.fairyproject.libs.packetevents.protocol.item.enchantment.type.StaticEnchantmentType;
import io.fairyproject.libs.packetevents.protocol.mapper.CopyableEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.DeepComparableEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.MappedEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.MappedEntityRefSet;
import io.fairyproject.libs.packetevents.protocol.mapper.MappedEntitySet;
import io.fairyproject.libs.packetevents.protocol.nbt.NBT;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.player.ClientVersion;
import io.fairyproject.libs.packetevents.util.mappings.TypesBuilderData;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType>,
DeepComparableEntity {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public MappedEntityRefSet<EnchantmentType> getExclusiveRefSet();

    public StaticComponentMap getEffects();

    @Deprecated
    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return EnchantmentType.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static EnchantmentType decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        EnchantmentDefinition definition = EnchantmentDefinition.decode((NBT)compound, wrapper);
        MappedEntityRefSet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decodeRefSet(tag, wrapper)).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, wrapper, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    @Deprecated
    public static NBT encode(EnchantmentType type, ClientVersion version) {
        return EnchantmentType.encode(type, PacketWrapper.createDummyWrapper(version));
    }

    public static NBT encode(EnchantmentType type, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        EnchantmentDefinition.encode(compound, wrapper, type.getDefinition());
        compound.set("description", type.getDescription(), wrapper.getSerializers(), wrapper);
        if (!type.getExclusiveRefSet().isEmpty()) {
            compound.set("exclusive_set", type.getExclusiveRefSet(), MappedEntitySet::encodeRefSet, wrapper);
        }
        if (!type.getEffects().isEmpty()) {
            compound.set("effects", type.getEffects(), IComponentMap::encode, wrapper);
        }
        return compound;
    }
}

