/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.world.chunk;

import io.fairyproject.libs.kyori.adventure.util.Index;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public enum HeightmapType {
    WORLD_SURFACE_WG("WORLD_SURFACE_WG", false),
    WORLD_SURFACE("WORLD_SURFACE", true),
    OCEAN_FLOOR_WG("OCEAN_FLOOR_WG", false),
    OCEAN_FLOOR("OCEAN_FLOOR", false),
    MOTION_BLOCKING("MOTION_BLOCKING", true),
    MOTION_BLOCKING_NO_LEAVES("MOTION_BLOCKING_NO_LEAVES", true);

    public static final Index<String, HeightmapType> SERIALIZATION_KEY_INDEX;
    private final String serializationKey;
    private final boolean client;

    private HeightmapType(String serializationKey, boolean client) {
        this.serializationKey = serializationKey;
        this.client = client;
    }

    @Nullable
    public static HeightmapType getHeightmapType(String serializationKey) {
        return SERIALIZATION_KEY_INDEX.value(serializationKey);
    }

    public static HeightmapType read(PacketWrapper<?> wrapper) {
        return wrapper.readEnum(HeightmapType.class);
    }

    public static void write(PacketWrapper<?> wrapper, HeightmapType type) {
        wrapper.writeEnum(type);
    }

    public String getSerializationKey() {
        return this.serializationKey;
    }

    public boolean isClient() {
        return this.client;
    }

    static {
        SERIALIZATION_KEY_INDEX = Index.create(HeightmapType.class, HeightmapType::getSerializationKey);
    }
}

