/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.world.states;

import io.fairyproject.libs.packetevents.PacketEvents;
import io.fairyproject.libs.packetevents.protocol.nbt.NBT;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTByte;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTInt;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTNumber;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTString;
import io.fairyproject.libs.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import io.fairyproject.libs.packetevents.protocol.player.ClientVersion;
import io.fairyproject.libs.packetevents.protocol.world.BlockFace;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Attachment;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Axis;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Bloom;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.CreakingHeartState;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.East;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Face;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Half;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Hinge;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Instrument;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Leaves;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Mode;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.North;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Orientation;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Part;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.SculkSensorPhase;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Shape;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.South;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Thickness;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Tilt;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.TrialSpawnerState;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.Type;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.VerticalDirection;
import io.fairyproject.libs.packetevents.protocol.world.states.enums.West;
import io.fairyproject.libs.packetevents.protocol.world.states.type.StateType;
import io.fairyproject.libs.packetevents.protocol.world.states.type.StateTypes;
import io.fairyproject.libs.packetevents.protocol.world.states.type.StateValue;
import io.fairyproject.libs.packetevents.util.adventure.AdventureIndexUtil;
import io.fairyproject.libs.packetevents.util.mappings.MappingHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WrappedBlockState {
    private static final ClientVersion[] MAPPING_VERSION_STEPS = new ClientVersion[]{ClientVersion.V_1_13, ClientVersion.V_1_13_2, ClientVersion.V_1_14, ClientVersion.V_1_15, ClientVersion.V_1_16, ClientVersion.V_1_16_2, ClientVersion.V_1_17, ClientVersion.V_1_19, ClientVersion.V_1_19_3, ClientVersion.V_1_19_4, ClientVersion.V_1_20, ClientVersion.V_1_20_2, ClientVersion.V_1_20_3, ClientVersion.V_1_20_5, ClientVersion.V_1_21_2, ClientVersion.V_1_21_4, ClientVersion.V_1_21_5, ClientVersion.V_1_21_6};
    private static final byte[] MAPPING_INDEXES;
    private static final ClientVersion[] MAPPING_VERSIONS;
    private static final byte AIR_MAPPING_INDEX = 0;
    private static final byte LEGACY_MAPPING_INDEX = 1;
    private static final byte HIGHEST_MAPPING_INDEX;
    private static final String MAPPINGS_ASSETS_PREFIX = "mappings/data/block_state/";
    private static final String MAPPINGS_ASSETS_LEGACY = "mappings/data/block_state/legacy";
    private static final boolean PRELOAD_BLOCK_STATE_MAPPINGS;
    private static final WrappedBlockState AIR;
    private static final Map<String, WrappedBlockState>[] BY_STRING;
    private static final Map<Integer, WrappedBlockState>[] BY_ID;
    private static final Map<WrappedBlockState, String>[] INTO_STRING;
    private static final Map<WrappedBlockState, Integer>[] INTO_ID;
    private static final Map<StateType, WrappedBlockState>[] DEFAULT_STATES;
    private static final Map<String, String> STRING_UPDATER;
    int globalID;
    StateType type;
    Map<StateValue, Object> data = new HashMap<StateValue, Object>(0);
    boolean hasClonedData = false;
    byte mappingsIndex;

    @Deprecated
    public WrappedBlockState(StateType type, String[] data, int globalID, byte mappingsIndex) {
        this.type = type;
        this.globalID = globalID;
        if (data != null) {
            for (String s : data) {
                try {
                    String[] split = s.split("=");
                    StateValue value = StateValue.byName(split[0]);
                    this.data.put(value, value.getParser().apply(split[1].toUpperCase(Locale.ROOT)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PacketEvents.getAPI().getLogManager().warn("Failed to parse block state: " + s);
                }
            }
        }
        this.mappingsIndex = mappingsIndex;
    }

    public WrappedBlockState(StateType type, Map<StateValue, Object> data, int globalID, byte mappingsIndex) {
        this.globalID = globalID;
        this.type = type;
        this.data = data;
        this.mappingsIndex = mappingsIndex;
    }

    private static byte loadMappings(ClientVersion version) {
        byte mappingsIndex = WrappedBlockState.getMappingsIndex(version);
        if (!PRELOAD_BLOCK_STATE_MAPPINGS && BY_ID[mappingsIndex].isEmpty()) {
            WrappedBlockState.loadMappings0(WrappedBlockState.getMappingsVersion(version), mappingsIndex);
        }
        return mappingsIndex;
    }

    private static synchronized void loadMappings0(ClientVersion version, byte mappingsIndex) {
        if (!BY_ID[mappingsIndex].isEmpty()) {
            return;
        }
        PacketEvents.getAPI().getLogger().info("Loading block mappings for " + (Object)((Object)version) + "/" + mappingsIndex + "...");
        long start = System.nanoTime();
        if (mappingsIndex == 1) {
            WrappedBlockState.loadLegacy(WrappedBlockState.buildStateDataCache());
        } else {
            WrappedBlockState.loadModern(WrappedBlockState.buildStateDataCache(), version);
        }
        double timeDiff = (double)(System.nanoTime() - start) / 1000000.0;
        PacketEvents.getAPI().getLogger().info("Finished loading block mappings for " + (Object)((Object)version) + "/" + mappingsIndex + " in " + timeDiff + "ms");
    }

    private static Map<Map<StateValue, Object>, StateCacheValue> buildStateDataCache() {
        HashMap<Map<StateValue, Object>, StateCacheValue> cache = new HashMap<Map<StateValue, Object>, StateCacheValue>();
        for (byte i = 0; i < HIGHEST_MAPPING_INDEX; i = (byte)(i + 1)) {
            Map<Integer, WrappedBlockState> map = BY_ID[i];
            if (map == null) continue;
            for (WrappedBlockState state : map.values()) {
                cache.computeIfAbsent(state.data, StateCacheValue::new);
            }
        }
        return cache;
    }

    public static WrappedBlockState decode(NBT nbt, ClientVersion version) {
        NBTCompound propsTag;
        if (nbt instanceof NBTString) {
            StateType type = StateTypes.getByName(((NBTString)nbt).getValue());
            return WrappedBlockState.getDefaultState(version, type);
        }
        NBTCompound compound = (NBTCompound)nbt;
        String blockName = compound.getStringTagValueOrThrow("Name");
        StateType block = StateTypes.getByName(blockName);
        WrappedBlockState state = WrappedBlockState.getDefaultState(version, block);
        if (state != AIR && (propsTag = compound.getCompoundTagOrNull("Properties")) != null) {
            for (Map.Entry<String, NBT> entry : propsTag.getTags().entrySet()) {
                Object value;
                StateValue stateValue = AdventureIndexUtil.indexValueOrThrow(StateValue.NAME_INDEX, entry.getKey());
                if (stateValue.getDataClass() == Boolean.TYPE) {
                    value = ((NBTByte)entry.getValue()).getAsBool();
                } else if (entry.getValue() instanceof NBTNumber) {
                    Number num = ((NBTNumber)entry.getValue()).getAsNumber();
                    value = stateValue.parse(num.toString());
                } else {
                    value = stateValue.parse(((NBTString)entry.getValue()).getValue());
                }
                state.getInternalData().put(stateValue, value);
            }
        }
        return state;
    }

    public static NBT encode(WrappedBlockState state, ClientVersion version) {
        WrappedBlockState defaultState;
        String stateTypeStr = state.type.getMapped().getName().toString();
        if (state.getInternalData().isEmpty() || state.equals(defaultState = WrappedBlockState.getDefaultState(version, state.type))) {
            return new NBTString(stateTypeStr);
        }
        NBTCompound propsTag = new NBTCompound();
        for (Map.Entry<StateValue, Object> dataEntry : state.getInternalData().entrySet()) {
            StateValue stateValue = dataEntry.getKey();
            if (Objects.equals(defaultState.getInternalData().get((Object)stateValue), dataEntry.getValue())) continue;
            NBT valueTag = stateValue.getDataClass() == Boolean.TYPE ? new NBTByte((Boolean)dataEntry.getValue()) : (stateValue.getDataClass() == Integer.TYPE ? new NBTInt((Integer)dataEntry.getValue()) : new NBTString(dataEntry.getValue().toString()));
            propsTag.setTag(stateValue.getName(), valueTag);
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("Name", new NBTString(stateTypeStr));
        compound.setTag("Properties", propsTag);
        return compound;
    }

    @NotNull
    public static WrappedBlockState getByGlobalId(int globalID) {
        return WrappedBlockState.getByGlobalId(globalID, true);
    }

    @NotNull
    public static WrappedBlockState getByGlobalId(int globalID, boolean clone) {
        return WrappedBlockState.getByGlobalId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), globalID, clone);
    }

    @NotNull
    public static WrappedBlockState getByGlobalId(ClientVersion version, int globalID) {
        return WrappedBlockState.getByGlobalId(version, globalID, true);
    }

    @NotNull
    public static WrappedBlockState getByGlobalId(ClientVersion version, int globalID, boolean clone) {
        if (globalID == 0) {
            return AIR;
        }
        byte mappingsIndex = WrappedBlockState.loadMappings(version);
        WrappedBlockState state = BY_ID[mappingsIndex].getOrDefault(globalID, AIR);
        return clone ? state.clone() : state;
    }

    @NotNull
    public static WrappedBlockState getByString(String string) {
        return WrappedBlockState.getByString(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), string);
    }

    @NotNull
    public static WrappedBlockState getByString(ClientVersion version, String string) {
        return WrappedBlockState.getByString(version, string, true);
    }

    @NotNull
    public static WrappedBlockState getByString(ClientVersion version, String string, boolean clone) {
        byte mappingsIndex = WrappedBlockState.loadMappings(version);
        WrappedBlockState state = BY_STRING[mappingsIndex].getOrDefault(string.replace("minecraft:", ""), AIR);
        return clone ? state.clone() : state;
    }

    @NotNull
    public static WrappedBlockState getDefaultState(StateType type) {
        return WrappedBlockState.getDefaultState(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), type);
    }

    @NotNull
    public static WrappedBlockState getDefaultState(ClientVersion version, StateType type) {
        return WrappedBlockState.getDefaultState(version, type, true);
    }

    @NotNull
    public static WrappedBlockState getDefaultState(ClientVersion version, StateType type, boolean clone) {
        if (type == StateTypes.AIR) {
            return AIR;
        }
        byte mappingsIndex = WrappedBlockState.loadMappings(version);
        WrappedBlockState state = DEFAULT_STATES[mappingsIndex].get(type);
        if (state == null) {
            PacketEvents.getAPI().getLogger().config("Default state for " + type.getName() + " is null. Returning AIR");
            return AIR;
        }
        return clone ? state.clone() : state;
    }

    private static byte getMappingsIndex(ClientVersion version) {
        return MAPPING_INDEXES[version.ordinal()];
    }

    private static ClientVersion getMappingsVersion(ClientVersion version) {
        return MAPPING_VERSIONS[version.ordinal()];
    }

    private static void loadLegacy(Map<Map<StateValue, Object>, StateCacheValue> cache) {
        HashMap<Integer, WrappedBlockState> stateByIdMap = new HashMap<Integer, WrappedBlockState>();
        HashMap<WrappedBlockState, Integer> stateToIdMap = new HashMap<WrappedBlockState, Integer>();
        HashMap<String, WrappedBlockState> stateByStringMap = new HashMap<String, WrappedBlockState>();
        HashMap<WrappedBlockState, String> stateToStringMap = new HashMap<WrappedBlockState, String>();
        HashMap<StateType, WrappedBlockState> stateTypeToBlockStateMap = new HashMap<StateType, WrappedBlockState>();
        try (SequentialNBTReader.Compound compound = MappingHelper.decompress(MAPPINGS_ASSETS_LEGACY);){
            compound.skipOne();
            for (Map.Entry<String, NBT> entry : (SequentialNBTReader.Compound)compound.next().getValue()) {
                SequentialNBTReader.Compound inner = (SequentialNBTReader.Compound)entry.getValue();
                StateType type = StateTypes.getByName(entry.getKey());
                if (type == null) {
                    PacketEvents.getAPI().getLogger().warning("Could not find type for " + entry.getKey());
                    inner.skip();
                    continue;
                }
                for (Map.Entry<String, NBT> element : inner) {
                    StateCacheValue stateCache;
                    String elementName = element.getKey();
                    int idIndex = elementName.indexOf(58);
                    int id = Integer.parseInt(elementName.substring(0, idIndex));
                    int data = Integer.parseInt(elementName.substring(idIndex + 1));
                    int combinedID = id << 4 | data;
                    SequentialNBTReader.Compound dataContent = (SequentialNBTReader.Compound)element.getValue();
                    if (dataContent.hasNext()) {
                        LinkedHashMap<StateValue, Object> dataMap = new LinkedHashMap<StateValue, Object>(3);
                        for (Map.Entry<String, NBT> props : dataContent) {
                            Object v;
                            StateValue state = StateValue.byName(props.getKey());
                            if (state == null) {
                                PacketEvents.getAPI().getLogger().warning("Could not find value for " + props.getKey());
                                continue;
                            }
                            NBT value = props.getValue();
                            if (value instanceof NBTByte) {
                                v = ((NBTByte)value).getAsInt() == 1;
                            } else if (value instanceof NBTNumber) {
                                v = ((NBTNumber)value).getAsInt();
                            } else if (value instanceof NBTString) {
                                v = ((NBTString)value).getValue();
                            } else {
                                PacketEvents.getAPI().getLogger().warning("Unknown NBT type in legacy mapping: " + value.getClass().getSimpleName());
                                continue;
                            }
                            dataMap.put(state, state.getParser().apply(v.toString().toUpperCase(Locale.ROOT)));
                        }
                        stateCache = cache.computeIfAbsent(dataMap, StateCacheValue::new);
                    } else {
                        stateCache = StateCacheValue.EMPTY;
                    }
                    String fullString = entry.getKey() + stateCache.getString();
                    WrappedBlockState state = new WrappedBlockState(type, stateCache.map, combinedID, 1);
                    stateByIdMap.put(combinedID, state);
                    stateToStringMap.put(state, fullString);
                    stateToIdMap.put(state, combinedID);
                    stateByStringMap.putIfAbsent(fullString, state);
                    stateTypeToBlockStateMap.putIfAbsent(type, state);
                }
            }
            WrappedBlockState.BY_ID[1] = stateByIdMap;
            WrappedBlockState.INTO_ID[1] = stateToIdMap;
            WrappedBlockState.BY_STRING[1] = stateByStringMap;
            WrappedBlockState.INTO_STRING[1] = stateToStringMap;
            WrappedBlockState.DEFAULT_STATES[1] = stateTypeToBlockStateMap;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load legacy block mappings", e);
        }
    }

    private static void loadModern(Map<Map<StateValue, Object>, StateCacheValue> cache, ClientVersion version) {
        try (SequentialNBTReader.Compound compound = MappingHelper.decompress(MAPPINGS_ASSETS_PREFIX + version.name());){
            compound.skipOne();
            byte mappingIndex = WrappedBlockState.getMappingsIndex(version);
            SequentialNBTReader.List list = (SequentialNBTReader.List)compound.next().getValue();
            HashMap<Integer, WrappedBlockState> stateByIdMap = new HashMap<Integer, WrappedBlockState>();
            HashMap<WrappedBlockState, Integer> stateToIdMap = new HashMap<WrappedBlockState, Integer>();
            HashMap<String, WrappedBlockState> stateByStringMap = new HashMap<String, WrappedBlockState>();
            HashMap<WrappedBlockState, String> stateToStringMap = new HashMap<WrappedBlockState, String>();
            HashMap<StateType, WrappedBlockState> stateTypeToBlockStateMap = new HashMap<StateType, WrappedBlockState>();
            int id = 0;
            for (NBT e : list) {
                SequentialNBTReader.Compound element = (SequentialNBTReader.Compound)e;
                String typeString = ((NBTString)element.next().getValue()).getValue();
                StateType type = StateTypes.getByName(typeString);
                if (type == null) {
                    for (Map.Entry<String, String> stringEntry : STRING_UPDATER.entrySet()) {
                        typeString = typeString.replace(stringEntry.getKey(), stringEntry.getValue());
                    }
                    type = StateTypes.getByName(typeString);
                    if (type == null) {
                        PacketEvents.getAPI().getLogger().warning("Unknown block type: " + typeString);
                        element.skip();
                        continue;
                    }
                }
                Object next = element.next();
                int defaultIdx = 0;
                if (!((String)next.getKey()).equals("def")) {
                    PacketEvents.getAPI().getLogger().warning("No default state for " + type + " using 0");
                } else {
                    defaultIdx = ((NBTNumber)next.getValue()).getAsInt();
                    next = element.next();
                }
                int index = 0;
                for (NBT nbt : (SequentialNBTReader.List)next.getValue()) {
                    StateCacheValue stateCache;
                    SequentialNBTReader.Compound dataContent = (SequentialNBTReader.Compound)nbt;
                    if (dataContent.hasNext()) {
                        LinkedHashMap<StateValue, Object> dataMap = new LinkedHashMap<StateValue, Object>(3);
                        for (Map.Entry<String, NBT> props : dataContent) {
                            Object v;
                            StateValue state = StateValue.byName(props.getKey());
                            if (state == null) {
                                PacketEvents.getAPI().getLogger().warning("Could not find value for " + props.getKey());
                                continue;
                            }
                            NBT value = props.getValue();
                            if (value instanceof NBTByte) {
                                v = ((NBTByte)value).getAsInt() == 1;
                            } else if (value instanceof NBTNumber) {
                                v = ((NBTNumber)value).getAsInt();
                            } else if (value instanceof NBTString) {
                                v = ((NBTString)value).getValue();
                            } else {
                                PacketEvents.getAPI().getLogger().warning("Unknown NBT typeString in modern mapping: " + value.getClass().getSimpleName());
                                continue;
                            }
                            dataMap.put(state, state.getParser().apply(v.toString().toUpperCase(Locale.ROOT)));
                        }
                        stateCache = cache.computeIfAbsent(dataMap, StateCacheValue::new);
                    } else {
                        stateCache = StateCacheValue.EMPTY;
                    }
                    String fullString = typeString + stateCache.getString();
                    WrappedBlockState state = new WrappedBlockState(type, stateCache.map, id, mappingIndex);
                    if (defaultIdx == index) {
                        stateTypeToBlockStateMap.put(type, state);
                    }
                    stateByStringMap.put(fullString, state);
                    stateByIdMap.put(id, state);
                    stateToStringMap.put(state, fullString);
                    stateToIdMap.put(state, id);
                    ++id;
                    ++index;
                }
            }
            WrappedBlockState.BY_ID[mappingIndex] = stateByIdMap;
            WrappedBlockState.INTO_ID[mappingIndex] = stateToIdMap;
            WrappedBlockState.BY_STRING[mappingIndex] = stateByStringMap;
            WrappedBlockState.INTO_STRING[mappingIndex] = stateToStringMap;
            WrappedBlockState.DEFAULT_STATES[mappingIndex] = stateTypeToBlockStateMap;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load modern block mappings", e);
        }
    }

    public WrappedBlockState clone() {
        return new WrappedBlockState(this.type, this.data, this.globalID, this.mappingsIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrappedBlockState)) {
            return false;
        }
        WrappedBlockState that = (WrappedBlockState)o;
        return this.type == that.type && this.data.equals(that.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public StateType getType() {
        return this.type;
    }

    public Object getData(StateValue stateValue) {
        return this.data.get((Object)stateValue);
    }

    public void setData(StateValue stateValue, Object object) {
        this.checkIfCloneNeeded();
        this.data.put(stateValue, object);
        this.checkIsStillValid();
    }

    public int getAge() {
        return (Integer)this.data.get((Object)StateValue.AGE);
    }

    public void setAge(int age) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.AGE, age);
        this.checkIsStillValid();
    }

    public boolean isAttached() {
        return (Boolean)this.data.get((Object)StateValue.ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ATTACHED, attached);
        this.checkIsStillValid();
    }

    public Attachment getAttachment() {
        return (Attachment)((Object)this.data.get((Object)StateValue.ATTACHMENT));
    }

    public void setAttachment(Attachment attachment) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ATTACHMENT, (Object)attachment);
        this.checkIsStillValid();
    }

    public Axis getAxis() {
        return (Axis)((Object)this.data.get((Object)StateValue.AXIS));
    }

    public void setAxis(Axis axis) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.AXIS, (Object)axis);
        this.checkIsStillValid();
    }

    public boolean isBerries() {
        return (Boolean)this.data.get((Object)StateValue.BERRIES);
    }

    public void setBerries(boolean berries) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BERRIES, berries);
        this.checkIsStillValid();
    }

    public int getBites() {
        return (Integer)this.data.get((Object)StateValue.BITES);
    }

    public void setBites(int bites) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BITES, bites);
        this.checkIsStillValid();
    }

    public boolean isBottom() {
        return (Boolean)this.data.get((Object)StateValue.BOTTOM);
    }

    public void setBottom(boolean bottom) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BOTTOM, bottom);
        this.checkIsStillValid();
    }

    public int getCandles() {
        return (Integer)this.data.get((Object)StateValue.CANDLES);
    }

    public void setCandles(int candles) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CANDLES, candles);
        this.checkIsStillValid();
    }

    public int getCharges() {
        return (Integer)this.data.get((Object)StateValue.CHARGES);
    }

    public void setCharges(int charges) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CHARGES, charges);
        this.checkIsStillValid();
    }

    public boolean isConditional() {
        return (Boolean)this.data.get((Object)StateValue.CONDITIONAL);
    }

    public void setConditional(boolean conditional) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CONDITIONAL, conditional);
        this.checkIsStillValid();
    }

    public int getDelay() {
        return (Integer)this.data.get((Object)StateValue.DELAY);
    }

    public void setDelay(int delay) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DELAY, delay);
        this.checkIsStillValid();
    }

    public boolean isDisarmed() {
        return (Boolean)this.data.get((Object)StateValue.DISARMED);
    }

    public void setDisarmed(boolean disarmed) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DISARMED, disarmed);
        this.checkIsStillValid();
    }

    public int getDistance() {
        return (Integer)this.data.get((Object)StateValue.DISTANCE);
    }

    public void setDistance(int distance) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DISTANCE, distance);
        this.checkIsStillValid();
    }

    public boolean isDown() {
        return (Boolean)this.data.get((Object)StateValue.DOWN);
    }

    public void setDown(boolean down) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DOWN, down);
        this.checkIsStillValid();
    }

    public boolean isDrag() {
        return (Boolean)this.data.get((Object)StateValue.DRAG);
    }

    public void setDrag(boolean drag) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DRAG, drag);
        this.checkIsStillValid();
    }

    public boolean isDusted() {
        return (Boolean)this.data.get((Object)StateValue.DUSTED);
    }

    public void setDusted(boolean dusted) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.DUSTED, dusted);
        this.checkIsStillValid();
    }

    public int getEggs() {
        return (Integer)this.data.get((Object)StateValue.EGGS);
    }

    public void setEggs(int eggs) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EGGS, eggs);
        this.checkIsStillValid();
    }

    public boolean isEnabled() {
        return (Boolean)this.data.get((Object)StateValue.ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ENABLED, enabled);
        this.checkIsStillValid();
    }

    public boolean isExtended() {
        return (Boolean)this.data.get((Object)StateValue.EXTENDED);
    }

    public void setExtended(boolean extended) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EXTENDED, extended);
        this.checkIsStillValid();
    }

    public boolean isEye() {
        return (Boolean)this.data.get((Object)StateValue.EYE);
    }

    public void setEye(boolean eye) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EYE, eye);
        this.checkIsStillValid();
    }

    public Face getFace() {
        return (Face)((Object)this.data.get((Object)StateValue.FACE));
    }

    public void setFace(Face face) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.FACE, (Object)face);
        this.checkIsStillValid();
    }

    public BlockFace getFacing() {
        return (BlockFace)((Object)this.data.get((Object)StateValue.FACING));
    }

    public void setFacing(BlockFace facing) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.FACING, (Object)facing);
        this.checkIsStillValid();
    }

    public int getFlowerAmount() {
        return (Integer)this.data.get((Object)StateValue.FLOWER_AMOUNT);
    }

    public void setFlowerAmount(int flowerAmount) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.FLOWER_AMOUNT, flowerAmount);
        this.checkIsStillValid();
    }

    public Half getHalf() {
        return (Half)((Object)this.data.get((Object)StateValue.HALF));
    }

    public void setHalf(Half half) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HALF, (Object)half);
        this.checkIsStillValid();
    }

    public boolean isHanging() {
        return (Boolean)this.data.get((Object)StateValue.HANGING);
    }

    public void setHanging(boolean hanging) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HANGING, hanging);
        this.checkIsStillValid();
    }

    public boolean isHasBook() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOOK);
    }

    public void setHasBook(boolean hasBook) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOOK, hasBook);
        this.checkIsStillValid();
    }

    public boolean isHasBottle0() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOTTLE_0);
    }

    public void setHasBottle0(boolean hasBottle0) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOTTLE_0, hasBottle0);
        this.checkIsStillValid();
    }

    public boolean isHasBottle1() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOTTLE_1);
    }

    public void setHasBottle1(boolean hasBottle1) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOTTLE_1, hasBottle1);
        this.checkIsStillValid();
    }

    public boolean isHasBottle2() {
        return (Boolean)this.data.get((Object)StateValue.HAS_BOTTLE_2);
    }

    public void setHasBottle2(boolean hasBottle2) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_BOTTLE_2, hasBottle2);
        this.checkIsStillValid();
    }

    public boolean isHasRecord() {
        return (Boolean)this.data.get((Object)StateValue.HAS_RECORD);
    }

    public void setHasRecord(boolean hasRecord) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HAS_RECORD, hasRecord);
        this.checkIsStillValid();
    }

    public int getHatch() {
        return (Integer)this.data.get((Object)StateValue.HATCH);
    }

    public void setHatch(int hatch) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HATCH, hatch);
        this.checkIsStillValid();
    }

    public Hinge getHinge() {
        return (Hinge)((Object)this.data.get((Object)StateValue.HINGE));
    }

    public void setHinge(Hinge hinge) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HINGE, (Object)hinge);
        this.checkIsStillValid();
    }

    public int getHoneyLevel() {
        return (Integer)this.data.get((Object)StateValue.HONEY_LEVEL);
    }

    public void setHoneyLevel(int honeyLevel) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HONEY_LEVEL, honeyLevel);
        this.checkIsStillValid();
    }

    public boolean isInWall() {
        return (Boolean)this.data.get((Object)StateValue.IN_WALL);
    }

    public void setInWall(boolean inWall) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.IN_WALL, inWall);
        this.checkIsStillValid();
    }

    public Instrument getInstrument() {
        return (Instrument)((Object)this.data.get((Object)StateValue.INSTRUMENT));
    }

    public void setInstrument(Instrument instrument) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.INSTRUMENT, (Object)instrument);
        this.checkIsStillValid();
    }

    public boolean isInverted() {
        return (Boolean)this.data.get((Object)StateValue.INVERTED);
    }

    public void setInverted(boolean inverted) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.INVERTED, inverted);
        this.checkIsStillValid();
    }

    public int getLayers() {
        return (Integer)this.data.get((Object)StateValue.LAYERS);
    }

    public void setLayers(int layers) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LAYERS, layers);
        this.checkIsStillValid();
    }

    public Leaves getLeaves() {
        return (Leaves)((Object)this.data.get((Object)StateValue.LEAVES));
    }

    public void setLeaves(Leaves leaves) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LEAVES, (Object)leaves);
        this.checkIsStillValid();
    }

    public int getLevel() {
        return (Integer)this.data.get((Object)StateValue.LEVEL);
    }

    public void setLevel(int level) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LEVEL, level);
        this.checkIsStillValid();
    }

    public boolean isLit() {
        return (Boolean)this.data.get((Object)StateValue.LIT);
    }

    public void setLit(boolean lit) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LIT, lit);
        this.checkIsStillValid();
    }

    public boolean isTip() {
        return (Boolean)this.data.get((Object)StateValue.TIP);
    }

    public void setTip(boolean tip) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TIP, tip);
        this.checkIsStillValid();
    }

    public boolean isLocked() {
        return (Boolean)this.data.get((Object)StateValue.LOCKED);
    }

    public void setLocked(boolean locked) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.LOCKED, locked);
        this.checkIsStillValid();
    }

    public Mode getMode() {
        return (Mode)((Object)this.data.get((Object)StateValue.MODE));
    }

    public void setMode(Mode mode) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.MODE, (Object)mode);
        this.checkIsStillValid();
    }

    public int getMoisture() {
        return (Integer)this.data.get((Object)StateValue.MOISTURE);
    }

    public void setMoisture(int moisture) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.MOISTURE, moisture);
        this.checkIsStillValid();
    }

    public North getNorth() {
        return (North)((Object)this.data.get((Object)StateValue.NORTH));
    }

    public void setNorth(North north) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.NORTH, (Object)north);
        this.checkIsStillValid();
    }

    public int getNote() {
        return (Integer)this.data.get((Object)StateValue.NOTE);
    }

    public void setNote(int note) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.NOTE, note);
        this.checkIsStillValid();
    }

    public boolean isOccupied() {
        return (Boolean)this.data.get((Object)StateValue.OCCUPIED);
    }

    public void setOccupied(boolean occupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.OCCUPIED, occupied);
        this.checkIsStillValid();
    }

    public boolean isShrieking() {
        return (Boolean)this.data.get((Object)StateValue.SHRIEKING);
    }

    public void setShrieking(boolean shrieking) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SHRIEKING, shrieking);
        this.checkIsStillValid();
    }

    public boolean isCanSummon() {
        return (Boolean)this.data.get((Object)StateValue.CAN_SUMMON);
    }

    public void setCanSummon(boolean canSummon) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CAN_SUMMON, canSummon);
        this.checkIsStillValid();
    }

    public boolean isOpen() {
        return (Boolean)this.data.get((Object)StateValue.OPEN);
    }

    public void setOpen(boolean open) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.OPEN, open);
        this.checkIsStillValid();
    }

    public Orientation getOrientation() {
        return (Orientation)((Object)this.data.get((Object)StateValue.ORIENTATION));
    }

    public void setOrientation(Orientation orientation) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ORIENTATION, (Object)orientation);
        this.checkIsStillValid();
    }

    public Part getPart() {
        return (Part)((Object)this.data.get((Object)StateValue.PART));
    }

    public void setPart(Part part) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.PART, (Object)part);
        this.checkIsStillValid();
    }

    public boolean isPersistent() {
        return (Boolean)this.data.get((Object)StateValue.PERSISTENT);
    }

    public void setPersistent(boolean persistent) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.PERSISTENT, persistent);
        this.checkIsStillValid();
    }

    public int getPickles() {
        return (Integer)this.data.get((Object)StateValue.PICKLES);
    }

    public void setPickles(int pickles) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.PICKLES, pickles);
        this.checkIsStillValid();
    }

    public int getPower() {
        return (Integer)this.data.get((Object)StateValue.POWER);
    }

    public void setPower(int power) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.POWER, power);
        this.checkIsStillValid();
    }

    public boolean isPowered() {
        return (Boolean)this.data.get((Object)StateValue.POWERED);
    }

    public void setPowered(boolean powered) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.POWERED, powered);
        this.checkIsStillValid();
    }

    public int getRotation() {
        return (Integer)this.data.get((Object)StateValue.ROTATION);
    }

    public void setRotation(int rotation) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ROTATION, rotation);
        this.checkIsStillValid();
    }

    public SculkSensorPhase getSculkSensorPhase() {
        return (SculkSensorPhase)((Object)this.data.get((Object)StateValue.SCULK_SENSOR_PHASE));
    }

    public void setSculkSensorPhase(SculkSensorPhase sculkSensorPhase) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SCULK_SENSOR_PHASE, (Object)sculkSensorPhase);
        this.checkIsStillValid();
    }

    public Shape getShape() {
        return (Shape)((Object)this.data.get((Object)StateValue.SHAPE));
    }

    public void setShape(Shape shape) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SHAPE, (Object)shape);
        this.checkIsStillValid();
    }

    public boolean isShort() {
        return (Boolean)this.data.get((Object)StateValue.SHORT);
    }

    public void setShort(boolean short_) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SHORT, short_);
        this.checkIsStillValid();
    }

    public boolean isSignalFire() {
        return (Boolean)this.data.get((Object)StateValue.SIGNAL_FIRE);
    }

    public void setSignalFire(boolean signalFire) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SIGNAL_FIRE, signalFire);
        this.checkIsStillValid();
    }

    public boolean isSlotZeroOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_0_OCCUPIED);
    }

    public void setSlotZeroOccupied(boolean slotZeroOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_0_OCCUPIED, slotZeroOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotOneOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_1_OCCUPIED);
    }

    public void setSlotOneOccupied(boolean slotOneOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_1_OCCUPIED, slotOneOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotTwoOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_2_OCCUPIED);
    }

    public void setSlotTwoOccupied(boolean slotTwoOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_2_OCCUPIED, slotTwoOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotThreeOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_3_OCCUPIED);
    }

    public void setSlotThreeOccupied(boolean slotThreeOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_3_OCCUPIED, slotThreeOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotFourOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_4_OCCUPIED);
    }

    public void setSlotFourOccupied(boolean slotFourOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_4_OCCUPIED, slotFourOccupied);
        this.checkIsStillValid();
    }

    public boolean isSlotFiveOccupied() {
        return (Boolean)this.data.get((Object)StateValue.SLOT_5_OCCUPIED);
    }

    public void setSlotFiveOccupied(boolean slotFiveOccupied) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SLOT_5_OCCUPIED, slotFiveOccupied);
        this.checkIsStillValid();
    }

    public boolean isSnowy() {
        return (Boolean)this.data.get((Object)StateValue.SNOWY);
    }

    public void setSnowy(boolean snowy) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SNOWY, snowy);
        this.checkIsStillValid();
    }

    public int getStage() {
        return (Integer)this.data.get((Object)StateValue.STAGE);
    }

    public void setStage(int stage) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.STAGE, stage);
        this.checkIsStillValid();
    }

    public South getSouth() {
        return (South)((Object)this.data.get((Object)StateValue.SOUTH));
    }

    public void setSouth(South south) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SOUTH, (Object)south);
        this.checkIsStillValid();
    }

    public Thickness getThickness() {
        return (Thickness)((Object)this.data.get((Object)StateValue.THICKNESS));
    }

    public void setThickness(Thickness thickness) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.THICKNESS, (Object)thickness);
        this.checkIsStillValid();
    }

    public Tilt getTilt() {
        return (Tilt)((Object)this.data.get((Object)StateValue.TILT));
    }

    public void setTilt(Tilt tilt) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TILT, (Object)tilt);
        this.checkIsStillValid();
    }

    public boolean isTriggered() {
        return (Boolean)this.data.get((Object)StateValue.TRIGGERED);
    }

    public void setTriggered(boolean triggered) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TRIGGERED, triggered);
        this.checkIsStillValid();
    }

    public Type getTypeData() {
        return (Type)((Object)this.data.get((Object)StateValue.TYPE));
    }

    public void setTypeData(Type type) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TYPE, (Object)type);
        this.checkIsStillValid();
    }

    public boolean isUnstable() {
        return (Boolean)this.data.get((Object)StateValue.UNSTABLE);
    }

    public void setUnstable(boolean unstable) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.UNSTABLE, unstable);
        this.checkIsStillValid();
    }

    public boolean isUp() {
        return (Boolean)this.data.get((Object)StateValue.UP);
    }

    public void setUp(boolean up) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.UP, up);
        this.checkIsStillValid();
    }

    public VerticalDirection getVerticalDirection() {
        return (VerticalDirection)((Object)this.data.get((Object)StateValue.VERTICAL_DIRECTION));
    }

    public void setVerticalDirection(VerticalDirection verticalDirection) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.VERTICAL_DIRECTION, (Object)verticalDirection);
        this.checkIsStillValid();
    }

    public boolean isWaterlogged() {
        return (Boolean)this.data.get((Object)StateValue.WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.WATERLOGGED, waterlogged);
        this.checkIsStillValid();
    }

    public East getEast() {
        return (East)((Object)this.data.get((Object)StateValue.EAST));
    }

    public void setEast(East west) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.EAST, (Object)west);
        this.checkIsStillValid();
    }

    public West getWest() {
        return (West)((Object)this.data.get((Object)StateValue.WEST));
    }

    public void setWest(West west) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.WEST, (Object)west);
        this.checkIsStillValid();
    }

    public Bloom getBloom() {
        return (Bloom)((Object)this.data.get((Object)StateValue.BLOOM));
    }

    public void setBloom(Bloom bloom) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.BLOOM, (Object)bloom);
        this.checkIsStillValid();
    }

    public boolean isCracked() {
        return (Boolean)this.data.get((Object)StateValue.CRACKED);
    }

    public void setCracked(boolean cracked) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CRACKED, cracked);
        this.checkIsStillValid();
    }

    public boolean isCrafting() {
        return (Boolean)this.data.get((Object)StateValue.CRAFTING);
    }

    public void setCrafting(boolean crafting) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CRAFTING, crafting);
        this.checkIsStillValid();
    }

    public TrialSpawnerState getTrialSpawnerState() {
        return (TrialSpawnerState)((Object)this.data.get((Object)StateValue.TRIAL_SPAWNER_STATE));
    }

    public void setTrialSpawnerState(TrialSpawnerState trialSpawnerState) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.TRIAL_SPAWNER_STATE, (Object)trialSpawnerState);
        this.checkIsStillValid();
    }

    @ApiStatus.Obsolete
    public CreakingHeartState getCreaking() {
        return (CreakingHeartState)((Object)this.data.get((Object)StateValue.CREAKING));
    }

    @ApiStatus.Obsolete
    public void setCreaking(CreakingHeartState creakingHeartState) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CREAKING, (Object)creakingHeartState);
        this.checkIsStillValid();
    }

    @ApiStatus.Obsolete
    public boolean isActive() {
        return (Boolean)this.data.get((Object)StateValue.ACTIVE);
    }

    @ApiStatus.Obsolete
    public void setActive(boolean active) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.ACTIVE, active);
        this.checkIsStillValid();
    }

    public boolean isNatural() {
        return (Boolean)this.data.get((Object)StateValue.NATURAL);
    }

    public void setNatural(boolean natural) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.NATURAL, natural);
        this.checkIsStillValid();
    }

    public int getSegmentAmount() {
        return (Integer)this.data.get((Object)StateValue.SEGMENT_AMOUNT);
    }

    public void setSegmentAmount(int segmentAmount) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.SEGMENT_AMOUNT, segmentAmount);
        this.checkIsStillValid();
    }

    public CreakingHeartState getCreakingHeartState() {
        return (CreakingHeartState)((Object)this.data.get((Object)StateValue.CREAKING_HEART_STATE));
    }

    public void setCreakingHeartState(CreakingHeartState creakingHeartState) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.CREAKING_HEART_STATE, (Object)creakingHeartState);
        this.checkIsStillValid();
    }

    public boolean isMap() {
        return (Boolean)this.data.get((Object)StateValue.MAP);
    }

    public void setMap(boolean map) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.MAP, map);
        this.checkIsStillValid();
    }

    public int getHydration() {
        return (Integer)this.data.get((Object)StateValue.HYDRATION);
    }

    public void setHydration(int hydration) {
        this.checkIfCloneNeeded();
        this.data.put(StateValue.HYDRATION, hydration);
        this.checkIsStillValid();
    }

    private void checkIfCloneNeeded() {
        if (!this.hasClonedData) {
            this.data = new HashMap<StateValue, Object>(this.data);
            this.hasClonedData = true;
        }
    }

    private void checkIsStillValid() {
        int oldGlobalID = this.globalID;
        this.globalID = this.getGlobalIdNoCache();
        if (this.globalID == -1) {
            WrappedBlockState blockState = BY_ID[this.mappingsIndex].getOrDefault(oldGlobalID, AIR).clone();
            this.type = blockState.type;
            this.globalID = blockState.globalID;
            this.data = new HashMap<StateValue, Object>(blockState.data);
            if (PacketEvents.getAPI().getSettings().isDebugEnabled()) {
                PacketEvents.getAPI().getLogManager().warn("Attempt to modify an unknown property for this game version and block!");
                PacketEvents.getAPI().getLogManager().warn("Block: " + this.type.getName());
                for (Map.Entry<StateValue, Object> entry : this.data.entrySet()) {
                    PacketEvents.getAPI().getLogManager().warn((Object)((Object)entry.getKey()) + ": " + entry.getValue());
                }
                new IllegalStateException("An invalid modification was made to a block!").printStackTrace();
            }
        }
    }

    @Deprecated
    public Map<StateValue, Object> getInternalData() {
        return this.data;
    }

    public int getGlobalId() {
        return this.globalID;
    }

    private int getGlobalIdNoCache() {
        return INTO_ID[this.mappingsIndex].getOrDefault(this, -1);
    }

    public String toString() {
        return INTO_STRING[this.mappingsIndex].get(this);
    }

    @ApiStatus.Internal
    public static void ensureLoad() {
        if (!PRELOAD_BLOCK_STATE_MAPPINGS) {
            return;
        }
        Logger logger = PacketEvents.getAPI().getLogger();
        logger.info("Preloading block mappings...");
        long start = System.nanoTime();
        HashMap<Map<StateValue, Object>, StateCacheValue> cache = new HashMap<Map<StateValue, Object>, StateCacheValue>();
        WrappedBlockState.loadLegacy(cache);
        for (ClientVersion version : MAPPING_VERSION_STEPS) {
            WrappedBlockState.loadModern(cache, version);
        }
        double timeDiff = (double)(System.nanoTime() - start) / 1000000.0;
        logger.info("Finish preloading block mappings in " + timeDiff + "ms");
    }

    static {
        PRELOAD_BLOCK_STATE_MAPPINGS = Boolean.getBoolean("packetevents.mappings.preload");
        ClientVersion[] versions = ClientVersion.values();
        MAPPING_INDEXES = new byte[versions.length];
        MAPPING_VERSIONS = new ClientVersion[versions.length];
        ClientVersion mappingVersion = versions[0];
        int j = 0;
        for (int i = 0; i < versions.length; ++i) {
            ClientVersion version = versions[i];
            if (j < MAPPING_VERSION_STEPS.length && version == MAPPING_VERSION_STEPS[j]) {
                ++j;
                mappingVersion = version;
            }
            WrappedBlockState.MAPPING_INDEXES[version.ordinal()] = (byte)(1 + j);
            WrappedBlockState.MAPPING_VERSIONS[version.ordinal()] = mappingVersion;
        }
        HIGHEST_MAPPING_INDEX = MAPPING_INDEXES[versions.length - 1];
        AIR = new WrappedBlockState(StateTypes.AIR, new EnumMap<StateValue, Object>(StateValue.class), 0, 0);
        BY_STRING = new Map[HIGHEST_MAPPING_INDEX + 1];
        BY_ID = new Map[HIGHEST_MAPPING_INDEX + 1];
        INTO_STRING = new Map[HIGHEST_MAPPING_INDEX + 1];
        INTO_ID = new Map[HIGHEST_MAPPING_INDEX + 1];
        DEFAULT_STATES = new Map[HIGHEST_MAPPING_INDEX + 1];
        STRING_UPDATER = new HashMap<String, String>();
        STRING_UPDATER.put("grass_path", "dirt_path");
        Arrays.fill(BY_STRING, Collections.emptyMap());
        Arrays.fill(BY_ID, Collections.emptyMap());
        Arrays.fill(INTO_STRING, Collections.emptyMap());
        Arrays.fill(INTO_ID, Collections.emptyMap());
        Arrays.fill(DEFAULT_STATES, Collections.emptyMap());
        String airName = AIR.getType().getMapped().getName().getKey();
        WrappedBlockState.BY_STRING[0] = Collections.singletonMap(airName, AIR);
        WrappedBlockState.BY_ID[0] = Collections.singletonMap(AIR.getGlobalId(), AIR);
        WrappedBlockState.INTO_STRING[0] = Collections.singletonMap(AIR, airName);
        WrappedBlockState.INTO_ID[0] = Collections.singletonMap(AIR, AIR.getGlobalId());
        WrappedBlockState.DEFAULT_STATES[0] = Collections.singletonMap(AIR.getType(), AIR);
    }

    private static final class StateCacheValue {
        public static final StateCacheValue EMPTY = new StateCacheValue(Collections.emptyMap());
        private final Map<StateValue, Object> map;
        private String string;

        public StateCacheValue(Map<StateValue, Object> map) {
            this.map = map;
        }

        public String getString() {
            if (this.string == null) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<StateValue, Object> entry : this.map.entrySet()) {
                    builder.append(entry.getKey().getName()).append('=').append(String.valueOf(entry.getValue()).toLowerCase(Locale.ROOT)).append(',');
                }
                this.string = builder.length() == 0 ? "" : '[' + builder.substring(0, builder.length() - 1) + ']';
            }
            return this.string;
        }
    }
}

