/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.util;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Either<L, R> {
    @Nullable
    private final L left;
    @Nullable
    private final R right;

    private Either(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> createLeft(L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> createRight(R right) {
        return new Either<Object, R>(null, right);
    }

    public Object get() {
        return this.left != null ? this.left : this.right;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    @Nullable
    public L getLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.right != null;
    }

    @Nullable
    public R getRight() {
        return this.right;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Either)) {
            return false;
        }
        Either either = (Either)obj;
        if (!Objects.equals(this.left, either.left)) {
            return false;
        }
        return Objects.equals(this.right, either.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

