/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.client;

import io.fairyproject.libs.packetevents.event.PacketReceiveEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.chat.LastSeenMessages;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientChatAck
extends PacketWrapper<WrapperPlayClientChatAck> {
    private LastSeenMessages.LegacyUpdate lastSeenMessages;
    private int offset;

    public WrapperPlayClientChatAck(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientChatAck(LastSeenMessages.LegacyUpdate lastSeenMessages) {
        super(PacketType.Play.Client.CHAT_ACK);
        this.lastSeenMessages = lastSeenMessages;
    }

    public WrapperPlayClientChatAck(int offset) {
        super(PacketType.Play.Client.CHAT_ACK);
        this.offset = offset;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            this.offset = this.readVarInt();
        } else {
            this.lastSeenMessages = this.readLegacyLastSeenMessagesUpdate();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            this.writeVarInt(this.offset);
        } else {
            this.writeLegacyLastSeenMessagesUpdate(this.lastSeenMessages);
        }
    }

    @Override
    public void copy(WrapperPlayClientChatAck wrapper) {
        this.lastSeenMessages = wrapper.lastSeenMessages;
        this.offset = wrapper.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public LastSeenMessages.LegacyUpdate getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    public void setLastSeenMessages(LastSeenMessages.LegacyUpdate lastSeenMessages) {
        this.lastSeenMessages = lastSeenMessages;
    }
}

