/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.server;

import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.item.ItemStack;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.protocol.player.Equipment;
import io.fairyproject.libs.packetevents.protocol.player.EquipmentSlot;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;

public class WrapperPlayServerEntityEquipment
extends PacketWrapper<WrapperPlayServerEntityEquipment> {
    private int entityId;
    private List<Equipment> equipment;

    public WrapperPlayServerEntityEquipment(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityEquipment(int entityId, List<Equipment> equipment) {
        super(PacketType.Play.Server.ENTITY_EQUIPMENT);
        this.entityId = entityId;
        this.equipment = equipment;
    }

    @Override
    public void read() {
        this.entityId = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10) ? this.readInt() : this.readVarInt();
        this.equipment = new ArrayList<Equipment>();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            byte value;
            do {
                value = this.readByte();
                EquipmentSlot equipmentSlot = EquipmentSlot.getById(this.serverVersion, value & 0x7F);
                ItemStack itemStack = this.readItemStack();
                this.equipment.add(new Equipment(equipmentSlot, itemStack));
            } while ((value & 0xFFFFFF80) != 0);
        } else {
            EquipmentSlot slot = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? EquipmentSlot.getById(this.serverVersion, this.readVarInt()) : EquipmentSlot.getById(this.serverVersion, (int)this.readShort());
            this.equipment.add(new Equipment(slot, this.readItemStack()));
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeInt(this.entityId);
        } else {
            this.writeVarInt(this.entityId);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            for (int i = 0; i < this.equipment.size(); ++i) {
                Equipment equipment = this.equipment.get(i);
                boolean last = i == this.equipment.size() - 1;
                this.writeByte(last ? equipment.getSlot().getId(this.serverVersion) : equipment.getSlot().getId(this.serverVersion) | 0xFFFFFF80);
                this.writeItemStack(equipment.getItem());
            }
        } else {
            Equipment equipment = this.equipment.get(0);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.writeVarInt(equipment.getSlot().getId(this.serverVersion));
            } else {
                this.writeShort(equipment.getSlot().getId(this.serverVersion));
            }
            this.writeItemStack(equipment.getItem());
        }
    }

    @Override
    public void copy(WrapperPlayServerEntityEquipment wrapper) {
        this.entityId = wrapper.entityId;
        this.equipment = wrapper.equipment;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public List<Equipment> getEquipment() {
        return this.equipment;
    }

    public void setEquipment(List<Equipment> equipment) {
        this.equipment = equipment;
    }
}

