/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.server;

import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.util.Vector3d;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerFacePlayer
extends PacketWrapper<WrapperPlayServerFacePlayer> {
    private EntitySection aimUnit;
    private Vector3d targetPosition;
    @Nullable
    private TargetEntity targetEntity;

    public WrapperPlayServerFacePlayer(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerFacePlayer(EntitySection aimUnit, Vector3d targetPosition, @Nullable TargetEntity targetEntity) {
        super(PacketType.Play.Server.FACE_PLAYER);
        this.aimUnit = aimUnit;
        this.targetPosition = targetPosition;
        this.targetEntity = targetEntity;
    }

    @Override
    public void read() {
        this.aimUnit = EntitySection.getById(this.readVarInt());
        this.targetPosition = new Vector3d(this.readDouble(), this.readDouble(), this.readDouble());
        this.targetEntity = (TargetEntity)this.readOptional(reader -> new TargetEntity(reader.readVarInt(), EntitySection.getById(reader.readVarInt())));
    }

    @Override
    public void write() {
        this.writeVarInt(this.aimUnit.getId());
        this.writeDouble(this.targetPosition.getX());
        this.writeDouble(this.targetPosition.getY());
        this.writeDouble(this.targetPosition.getZ());
        this.writeOptional(this.targetEntity, (wrapper, innerEntity) -> {
            wrapper.writeVarInt(innerEntity.getEntityId());
            wrapper.writeVarInt(innerEntity.getEntitySection().getId());
        });
    }

    @Override
    public void copy(WrapperPlayServerFacePlayer wrapper) {
        this.aimUnit = wrapper.aimUnit;
        this.targetPosition = wrapper.targetPosition;
        this.targetEntity = wrapper.targetEntity;
    }

    public EntitySection getAimUnit() {
        return this.aimUnit;
    }

    public void setAimUnit(EntitySection aimUnit) {
        this.aimUnit = aimUnit;
    }

    public Vector3d getTargetPosition() {
        return this.targetPosition;
    }

    public void setTargetPosition(Vector3d targetPosition) {
        this.targetPosition = targetPosition;
    }

    @Nullable
    public TargetEntity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(@Nullable TargetEntity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public static enum EntitySection {
        EYES,
        FEET;


        public int getId() {
            return this.ordinal();
        }

        public static EntitySection getById(int id) {
            return EntitySection.values()[id];
        }
    }

    public static class TargetEntity {
        private int entityId;
        private EntitySection entitySection;

        public TargetEntity(int entityId, EntitySection entitySection) {
            this.entityId = entityId;
            this.entitySection = entitySection;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public void setEntityId(int entityId) {
            this.entityId = entityId;
        }

        public EntitySection getEntitySection() {
            return this.entitySection;
        }

        public void setEntitySection(EntitySection entitySection) {
            this.entitySection = entitySection;
        }
    }
}

