/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.server;

import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.protocol.world.Direction;
import io.fairyproject.libs.packetevents.protocol.world.PaintingType;
import io.fairyproject.libs.packetevents.util.Vector3i;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerSpawnPainting
extends PacketWrapper<WrapperPlayServerSpawnPainting> {
    private int entityId;
    private UUID uuid;
    @Nullable
    private PaintingType type;
    private Vector3i position;
    private Direction direction;

    public WrapperPlayServerSpawnPainting(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerSpawnPainting(int entityId, Vector3i position, Direction direction) {
        this(entityId, new UUID(0L, 0L), null, position, direction);
    }

    public WrapperPlayServerSpawnPainting(int entityId, UUID uuid, Vector3i position, Direction direction) {
        this(entityId, uuid, null, position, direction);
    }

    public WrapperPlayServerSpawnPainting(int entityId, UUID uuid, @Nullable PaintingType type, Vector3i position, Direction direction) {
        super(PacketType.Play.Server.SPAWN_PAINTING);
        this.entityId = entityId;
        this.uuid = uuid;
        this.type = type;
        this.position = position;
        this.direction = direction;
    }

    @Override
    public void read() {
        this.entityId = this.readVarInt();
        this.uuid = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? this.readUUID() : new UUID(0L, 0L);
        this.type = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? PaintingType.getById(this.readVarInt()) : PaintingType.getByTitle(this.readString(13));
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.position = this.readBlockPosition();
        } else {
            int x = this.readInt();
            int y = this.readInt();
            int z = this.readInt();
            this.position = new Vector3i(x, y, z);
        }
        this.direction = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8) ? Direction.getByHorizontalIndex(this.readUnsignedByte()) : Direction.getByHorizontalIndex(this.readInt());
    }

    @Override
    public void write() {
        this.writeVarInt(this.entityId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.writeUUID(this.uuid);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeVarInt(this.type.getId());
        } else {
            this.writeString(this.type.getTitle(), 13);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            long positionVector = this.position.getSerializedPosition(this.serverVersion);
            this.writeLong(positionVector);
        } else {
            this.writeInt(this.position.x);
            this.writeShort(this.position.y);
            this.writeInt(this.position.z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.writeByte(this.direction.getHorizontalIndex());
        } else {
            this.writeInt(this.direction.getHorizontalIndex());
        }
    }

    @Override
    public void copy(WrapperPlayServerSpawnPainting wrapper) {
        this.entityId = wrapper.entityId;
        this.uuid = wrapper.uuid;
        this.type = wrapper.type;
        this.position = wrapper.position;
        this.direction = wrapper.direction;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Optional<PaintingType> getType() {
        return Optional.ofNullable(this.type);
    }

    public void setType(@Nullable PaintingType type) {
        this.type = type;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }
}

