/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.server;

import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.util.Vector3i;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public class WrapperPlayServerSpawnPosition
extends PacketWrapper<WrapperPlayServerSpawnPosition> {
    private Vector3i position;
    private Float angle;

    public WrapperPlayServerSpawnPosition(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerSpawnPosition(Vector3i position) {
        super(PacketType.Play.Server.SPAWN_POSITION);
        this.position = position;
    }

    public WrapperPlayServerSpawnPosition(Vector3i position, float angle) {
        super(PacketType.Play.Server.SPAWN_POSITION);
        this.position = position;
        this.angle = Float.valueOf(angle);
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.position = new Vector3i(this.readLong(), this.serverVersion);
        } else {
            int x = this.readInt();
            int y = this.readInt();
            int z = this.readInt();
            this.position = new Vector3i(x, y, z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.angle = Float.valueOf(this.readFloat());
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            long positionVector = this.position.getSerializedPosition(this.serverVersion);
            this.writeLong(positionVector);
        } else {
            this.writeInt(this.position.x);
            this.writeInt(this.position.y);
            this.writeInt(this.position.z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeFloat(this.angle.floatValue());
        }
    }

    @Override
    public void copy(WrapperPlayServerSpawnPosition wrapper) {
        this.position = wrapper.position;
        this.angle = wrapper.angle;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }

    public Optional<Float> getAngle() {
        return Optional.ofNullable(this.angle);
    }

    public void setAngle(float angle) {
        this.angle = Float.valueOf(angle);
    }
}

