/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.nametag;

import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.event.GlobalEventNode;
import io.fairyproject.event.Subscribe;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.kyori.adventure.text.format.NamedTextColor;
import io.fairyproject.libs.kyori.adventure.text.format.TextColor;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import io.fairyproject.log.Log;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.event.MCPlayerJoinEvent;
import io.fairyproject.mc.event.MCPlayerQuitEvent;
import io.fairyproject.mc.nametag.NameTag;
import io.fairyproject.mc.nametag.NameTagAdapter;
import io.fairyproject.mc.nametag.NameTagData;
import io.fairyproject.mc.nametag.NameTagList;
import io.fairyproject.mc.nametag.NameTagUpdateEvent;
import io.fairyproject.mc.nametag.update.DuoPlayerNameTagUpdate;
import io.fairyproject.mc.nametag.update.NameTagUpdate;
import io.fairyproject.mc.nametag.update.SinglePlayerNameTagUpdate;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.registry.player.MCPlayerRegistry;
import io.fairyproject.mc.scheduler.MCSchedulers;
import io.fairyproject.metadata.MetadataKey;
import io.fairyproject.util.Utility;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InjectableComponent
public class NameTagService {
    protected static MetadataKey<NameTagList> TEAM_INFO_KEY = MetadataKey.create("fairy:name-tag", NameTagList.class);
    private final AtomicInteger teamId = new AtomicInteger(0);
    private final Map<NameTag, NameTagData> nameTagData = new ConcurrentHashMap<NameTag, NameTagData>();
    private final List<NameTagAdapter> nameTagAdapters = new LinkedList<NameTagAdapter>();
    private final ContainerContext containerContext;
    private final MCPlayerRegistry mcPlayerRegistry;

    @PreInitialize
    public void onPreInitialize() {
        this.containerContext.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(NameTagAdapter.class)).withAddHandler(ContainerObjCollector.warpInstance(NameTagAdapter.class, this::register)).withRemoveHandler(ContainerObjCollector.warpInstance(NameTagAdapter.class, this::unregister)));
    }

    private CompletableFuture<?> runAsync(Runnable runnable) {
        return MCSchedulers.getGlobalScheduler().schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Log.error("An error occurred while running async task", throwable, new Object[0]);
            }
        }).getFuture();
    }

    @Subscribe
    public void onPlayerJoin(MCPlayerJoinEvent event) {
        for (NameTagData data : this.nameTagData.values()) {
            this.sendCreatePacket(event.getPlayer(), data);
        }
    }

    @Subscribe
    public void onPlayerQuit(MCPlayerQuitEvent event) {
        MCPlayer player = event.getPlayer();
        String name = player.getName();
        this.runAsync(() -> {
            this.removeNameFromAll(name);
            player.metadata().remove(TEAM_INFO_KEY);
        });
    }

    private void removeNameFromAll(String name) {
        for (MCPlayer player : this.mcPlayerRegistry.getAllPlayers()) {
            if (player.getName().equals(name)) {
                return;
            }
            if (!player.isOnline()) {
                return;
            }
            player.metadata().ifPresent(TEAM_INFO_KEY, list -> this.removeNameFromList(name, player, (NameTagList)list));
        }
    }

    private void removeNameFromList(String name, MCPlayer player, NameTagList list) {
        NameTagData data = list.get(name);
        if (data == null) {
            return;
        }
        list.remove(name);
        WrapperPlayServerTeams packet = new WrapperPlayServerTeams(data.getName(), WrapperPlayServerTeams.TeamMode.REMOVE_ENTITIES, (WrapperPlayServerTeams.ScoreBoardTeamInfo)null, name);
        MCProtocol.sendPacket(player, packet);
    }

    public void register(NameTagAdapter adapter) {
        this.nameTagAdapters.add(adapter);
        this.nameTagAdapters.sort((o1, o2) -> Integer.compare(o2.getWeight(), o1.getWeight()));
    }

    public void unregister(NameTagAdapter adapter) {
        this.nameTagAdapters.remove(adapter);
    }

    public Collection<NameTagAdapter> getNameTagAdapters() {
        return Collections.unmodifiableCollection(this.nameTagAdapters);
    }

    public CompletableFuture<?> updateFromThirdSide(MCPlayer target) {
        SinglePlayerNameTagUpdate update = NameTagUpdate.createAllToPlayer(target);
        return this.runAsync(() -> this.applyUpdate(update));
    }

    public CompletableFuture<?> updateFromFirstSide(MCPlayer player) {
        SinglePlayerNameTagUpdate update = NameTagUpdate.createPlayerToAll(player);
        return this.runAsync(() -> this.applyUpdate(update));
    }

    public CompletableFuture<?> update(MCPlayer player) {
        SinglePlayerNameTagUpdate firstSide = NameTagUpdate.createPlayerToAll(player);
        SinglePlayerNameTagUpdate thirdSide = NameTagUpdate.createAllToPlayer(player);
        return this.runAsync(() -> {
            this.applyUpdate(firstSide);
            this.applyUpdate(thirdSide);
        });
    }

    public CompletableFuture<?> update(MCPlayer target, MCPlayer player) {
        DuoPlayerNameTagUpdate update = NameTagUpdate.create(target, player);
        return this.runAsync(() -> this.applyUpdate(update));
    }

    public CompletableFuture<?> updateAll() {
        return this.runAsync(() -> this.applyUpdate(NameTagUpdate.all()));
    }

    protected void applyUpdate(@NotNull NameTagUpdate update) {
        switch (update.getType()) {
            case ALL: {
                this.applyUpdateAll();
                break;
            }
            case ALL_TO_PLAYER: {
                this.applyUpdateAllToPlayer((SinglePlayerNameTagUpdate)update);
                break;
            }
            case PLAYER_TO_ALL: {
                this.applyUpdatePlayerToAll((SinglePlayerNameTagUpdate)update);
                break;
            }
            case PLAYER_TO_PLAYER: {
                this.applyUpdatePlayerToPlayer((DuoPlayerNameTagUpdate)update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update type: " + (Object)((Object)update.getType()));
            }
        }
    }

    private void applyUpdatePlayerToPlayer(DuoPlayerNameTagUpdate update) {
        MCPlayer player = this.mcPlayerRegistry.findByPlatform(update.getPlayer());
        MCPlayer target = this.mcPlayerRegistry.findByPlatform(update.getTarget());
        if (player != null && target != null) {
            this.updateForInternal(player, target);
        }
    }

    private void applyUpdatePlayerToAll(SinglePlayerNameTagUpdate update) {
        MCPlayer target = this.mcPlayerRegistry.findByPlatform(update.getPlayer());
        if (target != null) {
            this.mcPlayerRegistry.getAllPlayers().forEach(player -> this.updateForInternal(target, (MCPlayer)player));
        }
    }

    private void applyUpdateAllToPlayer(SinglePlayerNameTagUpdate update) {
        MCPlayer target = this.mcPlayerRegistry.findPlayerByUuid(update.getPlayer());
        this.mcPlayerRegistry.getAllPlayers().forEach(player -> this.updateForInternal((MCPlayer)player, target));
    }

    private void applyUpdateAll() {
        Utility.twice(this.mcPlayerRegistry.getAllPlayers(), this::updateForInternal);
    }

    @Nullable
    public NameTag findNameTag(MCPlayer player, MCPlayer target) {
        for (NameTagAdapter adapter : this.nameTagAdapters) {
            NameTag nametag = adapter.fetch(player, target);
            if (nametag == null) continue;
            return nametag;
        }
        return null;
    }

    private void updateForInternal(MCPlayer player, MCPlayer target) {
        NameTag nameTag = this.findNameTag(player, target);
        if (nameTag == null) {
            return;
        }
        NameTagUpdateEvent event = new NameTagUpdateEvent(player, target, nameTag);
        GlobalEventNode.get().call(event);
        if (event.isCancelled()) {
            return;
        }
        nameTag = event.getNameTag();
        NameTagList list = player.metadata().getOrPut(TEAM_INFO_KEY, NameTagList::new);
        this.removeNameFromList(target.getName(), player, list);
        NameTagData current = this.getOrCreateData(nameTag);
        list.add(target.getName(), current);
        WrapperPlayServerTeams packet = new WrapperPlayServerTeams(current.getName(), WrapperPlayServerTeams.TeamMode.ADD_ENTITIES, (WrapperPlayServerTeams.ScoreBoardTeamInfo)null, target.getName());
        MCProtocol.sendPacket(player, packet);
    }

    @Nullable
    protected NameTagData getData(NameTag nameTag) {
        return this.nameTagData.getOrDefault(nameTag, null);
    }

    protected NameTagData getOrCreateData(NameTag nameTag) {
        NameTagData data = this.getData(nameTag);
        if (data != null) {
            return data;
        }
        NameTagData newData = new NameTagData(this.generateTeamName(), nameTag);
        this.nameTagData.put(nameTag, newData);
        this.sendDataToAll(newData);
        return newData;
    }

    private void sendDataToAll(NameTagData newData) {
        for (MCPlayer player : this.mcPlayerRegistry.getAllPlayers()) {
            this.sendCreatePacket(player, newData);
        }
    }

    private String generateTeamName() {
        return "team-" + this.teamId.getAndIncrement();
    }

    private void sendCreatePacket(MCPlayer mcPlayer, NameTagData data) {
        TextColor color;
        WrapperPlayServerTeams.NameTagVisibility packetVisibility;
        NameTag nameTag = data.getNameTag();
        Component prefix = Component.empty();
        if (nameTag.getPrefix() != null) {
            prefix = nameTag.getPrefix();
        }
        Component suffix = Component.empty();
        if (nameTag.getSuffix() != null) {
            suffix = nameTag.getSuffix();
        }
        if ((packetVisibility = nameTag.getNameTagVisibility()) == null) {
            packetVisibility = WrapperPlayServerTeams.NameTagVisibility.ALWAYS;
        }
        if ((color = nameTag.getColor()) == null && (color = prefix.color()) == null) {
            color = NamedTextColor.WHITE;
        }
        WrapperPlayServerTeams packet = new WrapperPlayServerTeams(data.getName(), WrapperPlayServerTeams.TeamMode.CREATE, new WrapperPlayServerTeams.ScoreBoardTeamInfo(Component.empty(), prefix, suffix, packetVisibility, WrapperPlayServerTeams.CollisionRule.ALWAYS, NamedTextColor.nearestTo(color), WrapperPlayServerTeams.OptionData.NONE), new String[0]);
        MCProtocol.sendPacket(mcPlayer, packet);
    }

    public NameTagService(ContainerContext containerContext, MCPlayerRegistry mcPlayerRegistry) {
        this.containerContext = containerContext;
        this.mcPlayerRegistry = mcPlayerRegistry;
    }
}

