/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.protocol;

import io.fairyproject.Debug;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.container.PreDestroy;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.event.GlobalEventNode;
import io.fairyproject.libs.packetevents.PacketEvents;
import io.fairyproject.libs.packetevents.PacketEventsAPI;
import io.fairyproject.libs.packetevents.event.PacketListener;
import io.fairyproject.libs.packetevents.event.PacketListenerAbstract;
import io.fairyproject.libs.packetevents.event.PacketListenerCommon;
import io.fairyproject.libs.packetevents.event.PacketListenerPriority;
import io.fairyproject.libs.packetevents.event.PacketReceiveEvent;
import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.util.TimeStampMode;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.protocol.PacketEventsBuilder;
import io.fairyproject.mc.protocol.event.MCPlayerPacketReceiveEvent;
import io.fairyproject.mc.protocol.event.MCPlayerPacketSendEvent;
import io.fairyproject.mc.protocol.packet.PacketSender;
import io.fairyproject.mc.registry.player.MCPlayerRegistry;
import io.fairyproject.mc.version.MCVersionMappingRegistry;
import io.fairyproject.util.terminable.Terminable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MCProtocol {
    public static MCProtocol INSTANCE;
    private final ContainerContext context;
    private final MCPlayerRegistry playerRegistry;
    private final MCVersionMappingRegistry mappingRegistry;
    private final PacketSender packetSender;
    private PacketEventsAPI<?> packetEvents;
    private final Map<Class<?>, PacketListenerCommon> listenerCommonMap = new ConcurrentHashMap();

    public static void loadProtocol(PacketEventsBuilder packetEventsBuilder) {
        PacketEvents.setAPI(packetEventsBuilder.build());
        PacketEvents.getAPI().load();
        System.out.printf("Loaded PacketEvents with version %s on minecraft version %s%n", new Object[]{PacketEvents.getAPI().getVersion(), PacketEvents.getAPI().getServerManager().getVersion()});
    }

    @PreInitialize
    public void onPreInitialize() {
        INSTANCE = this;
        this.packetEvents = PacketEvents.getAPI();
        this.registerPacketListenerObjectCollector();
        this.registerMCEventTransformer();
        Debug.log("Loaded MCProtocol with PacketEvents version %s on minecraft version %s", new Object[]{this.packetEvents.getVersion(), this.packetEvents.getServerManager().getVersion()});
    }

    @PostInitialize
    public void onPostInitialize() {
        this.packetEvents.getSettings().debug(false).bStats(true).checkForUpdates(false).timeStampMode(TimeStampMode.MILLIS);
        this.packetEvents.init();
    }

    private void registerMCEventTransformer() {
        this.packetEvents.getEventManager().registerListener(new PacketListener(){

            @Override
            public void onPacketReceive(PacketReceiveEvent event) {
                Object player = event.getPlayer();
                if (player == null) {
                    return;
                }
                MCPlayer mcPlayer = MCProtocol.this.playerRegistry.findByPlatform(player);
                if (mcPlayer != null) {
                    GlobalEventNode.get().call(new MCPlayerPacketReceiveEvent(mcPlayer, event));
                }
            }

            @Override
            public void onPacketSend(PacketSendEvent event) {
                Object player = event.getPlayer();
                if (player == null) {
                    return;
                }
                MCPlayer mcPlayer = MCProtocol.this.playerRegistry.findByPlatform(player);
                if (mcPlayer != null) {
                    GlobalEventNode.get().call(new MCPlayerPacketSendEvent(mcPlayer, event));
                }
            }
        }, PacketListenerPriority.LOWEST);
    }

    private void registerPacketListenerObjectCollector() {
        this.context.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(PacketListener.class)).withAddHandler(ContainerObjCollector.warpInstance(PacketListener.class, obj -> {
            if (obj instanceof PacketListenerCommon) {
                PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)((Object)obj));
            } else {
                PacketListenerAbstract listener = obj.asAbstract(PacketListenerPriority.NORMAL);
                PacketEvents.getAPI().getEventManager().registerListener(listener);
                this.listenerCommonMap.put(obj.getClass(), listener);
            }
        })).withRemoveHandler(ContainerObjCollector.warpInstance(PacketListener.class, obj -> {
            if (obj instanceof PacketListenerCommon) {
                PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)((Object)obj));
            } else {
                PacketListenerCommon listenerCommon = this.listenerCommonMap.remove(obj.getClass());
                if (listenerCommon != null) {
                    PacketEvents.getAPI().getEventManager().unregisterListener(listenerCommon);
                }
            }
        })));
    }

    @PreDestroy
    public void onPostDestroy() {
        this.packetEvents.terminate();
    }

    public static void sendPacket(MCPlayer mcPlayer, PacketWrapper<?> packetWrapper) {
        INSTANCE.getPacketSender().sendPacket(mcPlayer, packetWrapper);
    }

    public static Terminable listen(PacketListenerCommon packetListener) {
        INSTANCE.getPacketEvents().getEventManager().registerListener(packetListener);
        return () -> INSTANCE.getPacketEvents().getEventManager().unregisterListener(packetListener);
    }

    public ContainerContext getContext() {
        return this.context;
    }

    public MCPlayerRegistry getPlayerRegistry() {
        return this.playerRegistry;
    }

    public MCVersionMappingRegistry getMappingRegistry() {
        return this.mappingRegistry;
    }

    public PacketSender getPacketSender() {
        return this.packetSender;
    }

    public PacketEventsAPI<?> getPacketEvents() {
        return this.packetEvents;
    }

    public Map<Class<?>, PacketListenerCommon> getListenerCommonMap() {
        return this.listenerCommonMap;
    }

    public MCProtocol(ContainerContext context, MCPlayerRegistry playerRegistry, MCVersionMappingRegistry mappingRegistry, PacketSender packetSender) {
        this.context = context;
        this.playerRegistry = playerRegistry;
        this.mappingRegistry = mappingRegistry;
        this.packetSender = packetSender;
    }
}

