/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.registry.player;

import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.event.GlobalEventNode;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.event.NativePlayerLoginEvent;
import io.fairyproject.mc.registry.player.MCPlayerPlatformOperator;
import io.fairyproject.mc.registry.player.MCPlayerRegistry;

@InjectableComponent
public class MCPlayerListener {
    private final MCPlayerRegistry registry;
    private final MCPlayerPlatformOperator platformOperator;
    private final GlobalEventNode eventNode;

    @PostInitialize
    public void onPostInitialize() {
        this.eventNode.addListener(NativePlayerLoginEvent.class, this::onNativePlayerLogin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNativePlayerLogin(NativePlayerLoginEvent event) {
        MCPlayer mcPlayer = this.platformOperator.create(event.getName(), event.getUuid(), event.getAddress());
        Object nativePlayer = event.getNativePlayer();
        mcPlayer.setNative(nativePlayer);
        MCPlayerRegistry.JOIN_QUIT_LOCK.lock();
        try {
            this.registry.addPlayer(mcPlayer);
        }
        finally {
            MCPlayerRegistry.JOIN_QUIT_LOCK.unlock();
        }
    }

    public MCPlayerListener(MCPlayerRegistry registry, MCPlayerPlatformOperator platformOperator, GlobalEventNode eventNode) {
        this.registry = registry;
        this.platformOperator = platformOperator;
        this.eventNode = eventNode;
    }
}

