/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.registry.player;

import io.fairyproject.container.PostInitialize;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.registry.player.MCPlayerPlatformOperator;
import io.fairyproject.mc.registry.player.MCPlayerRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCPlayerRegistryImpl
implements MCPlayerRegistry {
    private final MCPlayerPlatformOperator playerPlatformOperator;
    protected final Map<UUID, MCPlayer> players = new ConcurrentHashMap<UUID, MCPlayer>();

    @PostInitialize
    public void onPostInitialize() {
        for (MCPlayer mcPlayer : this.playerPlatformOperator.loadOnlinePlayers()) {
            this.addPlayer(mcPlayer);
        }
    }

    @Override
    @NotNull
    public MCPlayer findPlayerByUuid(@NotNull UUID uuid) {
        MCPlayer mcPlayer = this.players.get(uuid);
        if (mcPlayer == null) {
            throw new IllegalArgumentException("Player with UUID " + uuid + " does not exist");
        }
        return mcPlayer;
    }

    @Override
    @NotNull
    public MCPlayer findPlayerByName(@NotNull String name) {
        MCPlayer mcPlayer = this.players.values().stream().filter(player -> player.getName().equals(name)).findFirst().orElse(null);
        if (mcPlayer == null) {
            throw new IllegalArgumentException("Player with name " + name + " does not exist");
        }
        return mcPlayer;
    }

    @Override
    @NotNull
    public MCPlayer getByPlatform(@NotNull Object platformPlayer) {
        UUID uuid = this.playerPlatformOperator.getUniqueId(platformPlayer);
        MCPlayer mcPlayer = this.players.get(uuid);
        if (mcPlayer == null) {
            throw new IllegalArgumentException("Player with UUID " + uuid + " does not exist");
        }
        return mcPlayer;
    }

    @Override
    @Nullable
    public MCPlayer findByPlatform(@NotNull Object platformPlayer) {
        UUID uuid = this.playerPlatformOperator.getUniqueId(platformPlayer);
        return this.players.get(uuid);
    }

    @Override
    public void addPlayer(@NotNull MCPlayer player) {
        if (this.players.containsKey(player.getUUID())) {
            throw new IllegalArgumentException("Player with UUID " + player.getUUID() + " already exists");
        }
        this.players.put(player.getUUID(), player);
    }

    @Override
    @Nullable
    public MCPlayer removePlayer(@NotNull UUID uuid) {
        MCPlayer retVal = this.players.remove(uuid);
        if (retVal == null) {
            throw new IllegalArgumentException("Player with UUID " + uuid + " does not exist");
        }
        return retVal;
    }

    public void removePlayer(@NotNull MCPlayer player) {
        this.removePlayer(player.getUUID());
    }

    @Override
    public Collection<MCPlayer> getAllPlayers() {
        return this.players.values();
    }

    public MCPlayerRegistryImpl(MCPlayerPlatformOperator playerPlatformOperator) {
        this.playerPlatformOperator = playerPlatformOperator;
    }
}

