/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.version.cache;

import io.fairyproject.Fairy;
import io.fairyproject.libs.gson.Gson;
import io.fairyproject.libs.gson.JsonArray;
import io.fairyproject.libs.gson.stream.JsonReader;
import io.fairyproject.log.Log;
import io.fairyproject.mc.version.cache.MCVersionMappingCache;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;

public class MCVersionMappingCacheImpl
implements MCVersionMappingCache {
    private final Gson gson;

    @Override
    public JsonArray read() {
        File dataFolder = Fairy.getPlatform().getDataFolder();
        Path path = new File(dataFolder, "cache-protocol-versions.json").toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return (JsonArray)this.gson.fromJson(new JsonReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]))), (Type)((Object)JsonArray.class));
        }
        catch (IOException e) {
            Log.error("Failed to read version mappings from file", e, new Object[0]);
            return null;
        }
    }

    @Override
    @NotNull
    public JsonArray load() throws IOException {
        String url = "https://raw.githubusercontent.com/PrismarineJS/minecraft-data/master/data/pc/common/protocolVersions.json";
        try {
            URLConnection urlConnection = new URL(url).openConnection();
            return (JsonArray)this.gson.fromJson(new JsonReader(new InputStreamReader(urlConnection.getInputStream())), (Type)((Object)JsonArray.class));
        }
        catch (UnknownHostException e) {
            Log.error("Unable to locate raw.githubusercontent.com, please check your internet connection.", new Object[0]);
            Log.error("If you are behind a proxy, please make sure to configure it properly.", new Object[0]);
            Log.error("If you are using a firewall, please make sure to whitelist the connection.", new Object[0]);
            Log.error("Fairy is trying to load " + url + " to get the latest protocol versions, please whitelist it at least once.", new Object[0]);
            SneakyThrowUtil.sneakyThrow(e);
            return null;
        }
    }

    @Override
    public void write(@NotNull JsonArray jsonElements) {
        File dataFolder = Fairy.getPlatform().getDataFolder();
        Path path = new File(dataFolder, "cache-protocol-versions.json").toPath();
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            Files.write(path, this.gson.toJson(jsonElements).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            Log.error("Failed to write version mappings to file", e, new Object[0]);
        }
    }

    public MCVersionMappingCacheImpl(Gson gson) {
        this.gson = gson;
    }
}

