/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.metadata;

import io.fairyproject.metadata.TransientValue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class WeakValue<T>
implements TransientValue<T> {
    private final WeakReference<T> value;

    public static <T> WeakValue<T> of(T value) {
        Objects.requireNonNull(value, "value");
        return new WeakValue<T>(value);
    }

    public static <T> Supplier<WeakValue<T>> supplied(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        return () -> {
            Object value = supplier.get();
            Objects.requireNonNull(value, "value");
            return new WeakValue(value);
        };
    }

    private WeakValue(T value) {
        this.value = new WeakReference<T>(value);
    }

    @Override
    @Nullable
    public T getOrNull() {
        return this.value.get();
    }

    @Override
    public boolean shouldExpire() {
        return this.value.get() == null;
    }
}

