/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.plugin;

import io.fairyproject.plugin.Plugin;
import io.fairyproject.plugin.PluginAction;
import io.fairyproject.plugin.PluginDescription;
import io.fairyproject.plugin.PluginHandler;
import io.fairyproject.plugin.PluginListenerAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class PluginManager {
    public static PluginManager INSTANCE;
    private final Map<String, Plugin> plugins;
    private final List<PluginListenerAdapter> listeners;
    private final PluginHandler pluginHandler;

    public PluginManager(PluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
        this.plugins = new ConcurrentHashMap<String, Plugin>();
        this.listeners = new ArrayList<PluginListenerAdapter>();
    }

    public void unload() {
        this.plugins.clear();
        this.listeners.clear();
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginPreLoaded(ClassLoader classLoader, PluginDescription description, PluginAction action, CompletableFuture<Plugin> completableFuture) {
        List<PluginListenerAdapter> list = this.listeners;
        synchronized (list) {
            this.listeners.forEach(listenerAdapter -> listenerAdapter.onPluginPreLoaded(classLoader, description, action, completableFuture));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginInitial(Plugin plugin) {
        List<PluginListenerAdapter> list = this.listeners;
        synchronized (list) {
            this.listeners.forEach(listenerAdapter -> listenerAdapter.onPluginInitial(plugin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginEnable(Plugin plugin) {
        List<PluginListenerAdapter> list = this.listeners;
        synchronized (list) {
            this.listeners.forEach(listenerAdapter -> listenerAdapter.onPluginEnable(plugin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginDisable(Plugin plugin) {
        List<PluginListenerAdapter> list = this.listeners;
        synchronized (list) {
            this.listeners.forEach(listenerAdapter -> listenerAdapter.onPluginDisable(plugin));
        }
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name.toLowerCase());
    }

    public void addPlugin(Plugin plugin) {
        String name = plugin.getName().toLowerCase();
        if (this.plugins.containsKey(name)) {
            throw new IllegalArgumentException("Plugin " + name + " already registered!");
        }
        this.plugins.put(name, plugin);
    }

    public void removePlugin(Plugin plugin) {
        String name = plugin.getName().toLowerCase();
        if (!this.plugins.containsKey(name)) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " not registered!");
        }
        this.plugins.remove(name);
    }

    public void callFrameworkFullyDisable() {
        this.plugins.values().forEach(Plugin::onFrameworkFullyDisable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(PluginListenerAdapter listenerAdapter) {
        List<PluginListenerAdapter> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listenerAdapter);
            this.listeners.sort(Collections.reverseOrder(Comparator.comparingInt(PluginListenerAdapter::priority)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PluginListenerAdapter listenerAdapter) {
        List<PluginListenerAdapter> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listenerAdapter);
        }
    }

    @Nullable
    public Plugin getPluginByClass(Class<?> type) {
        String name = this.pluginHandler.getPluginByClass(type);
        if (name == null) {
            return null;
        }
        return this.getPlugin(name);
    }

    public static boolean isInitialized() {
        return INSTANCE != null;
    }

    public static void initialize(PluginHandler pluginHandler) {
        if (INSTANCE != null) {
            throw new IllegalArgumentException("Don't Initialize twice!");
        }
        INSTANCE = new PluginManager(pluginHandler);
    }

    public List<PluginListenerAdapter> getListeners() {
        return this.listeners;
    }
}

