/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.scheduler.repeat;

import io.fairyproject.scheduler.ScheduledTask;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import java.time.Duration;

public class LengthRepeatPredicate<T>
implements RepeatPredicate<T> {
    private final long startTime;
    private final Duration duration;
    private final T defaultValue;

    @Override
    public boolean shouldContinue(ScheduledTask<?> task) {
        return System.currentTimeMillis() - this.startTime < this.duration.toMillis();
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public LengthRepeatPredicate(long startTime, Duration duration, T defaultValue) {
        this.startTime = startTime;
        this.duration = duration;
        this.defaultValue = defaultValue;
    }
}

