/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.sidebar;

import io.fairyproject.Fairy;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.event.Subscribe;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.data.MCMetadata;
import io.fairyproject.mc.event.MCPlayerJoinEvent;
import io.fairyproject.mc.event.MCPlayerQuitEvent;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.registry.player.MCPlayerRegistry;
import io.fairyproject.mc.scheduler.MCSchedulerProvider;
import io.fairyproject.scheduler.response.TaskResponse;
import io.fairyproject.sidebar.Sidebar;
import io.fairyproject.sidebar.SidebarAdapter;
import io.fairyproject.sidebar.SidebarLine;
import io.fairyproject.sidebar.SidebarProvider;
import io.fairyproject.sidebar.handler.SidebarHandler;
import io.fairyproject.sidebar.handler.legacy.LegacySidebarHandler;
import io.fairyproject.sidebar.handler.legacy.V13LegacySidebarHandler;
import io.fairyproject.sidebar.handler.modern.LunarFixModernSidebarHandler;
import io.fairyproject.sidebar.handler.modern.ModernSidebarHandler;
import io.fairyproject.util.Stacktrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@InjectableComponent
public class SidebarService {
    private static final boolean LUNAR_CLIENT_FIX = System.getProperty("fairy.sidebar.lunar-client-fix", "true").equalsIgnoreCase("true");
    private final List<SidebarProvider> providers = new ArrayList<SidebarProvider>();
    private final AtomicBoolean taskState = new AtomicBoolean(false);
    private final ContainerContext containerContext;
    private final MCProtocol mcProtocol;
    private final MCPlayerRegistry mcPlayerRegistry;
    private final MCSchedulerProvider mcSchedulerProvider;
    private SidebarHandler sidebarHandler;

    @PreInitialize
    public void onPreInitialize() {
        ServerVersion version = this.mcProtocol.getPacketEvents().getServerManager().getVersion();
        this.sidebarHandler = version.isNewerThanOrEquals(ServerVersion.V_1_20_3) ? (LUNAR_CLIENT_FIX ? new LunarFixModernSidebarHandler() : new ModernSidebarHandler()) : (version.isNewerThanOrEquals(ServerVersion.V_1_13) ? new V13LegacySidebarHandler() : new LegacySidebarHandler());
        this.containerContext.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(SidebarAdapter.class)).withAddHandler(ContainerObjCollector.warpInstance(SidebarAdapter.class, adapter -> this.addProvider(SidebarAdapter.asProvider(adapter)))).withRemoveHandler(ContainerObjCollector.warpInstance(SidebarAdapter.class, adapter -> this.removeProvider(SidebarAdapter.asProvider(adapter)))));
        this.containerContext.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(SidebarProvider.class)).withAddHandler(ContainerObjCollector.warpInstance(SidebarProvider.class, this::addProvider)).withRemoveHandler(ContainerObjCollector.warpInstance(SidebarProvider.class, this::removeProvider)));
    }

    @PostInitialize
    public void onPostInitialize() {
        this.scheduleTask();
    }

    @Subscribe
    public void onPlayerJoin(MCPlayerJoinEvent event) {
        this.getOrCreate(event.getPlayer());
    }

    @Subscribe
    public void onPlayerQuit(MCPlayerQuitEvent event) {
        this.remove(event.getPlayer());
    }

    public void addProvider(SidebarProvider provider) {
        this.providers.add(provider);
        this.providers.sort(Collections.reverseOrder(Comparator.comparingInt(SidebarProvider::getPriority)));
        this.scheduleTask();
    }

    public void removeProvider(SidebarProvider provider) {
        this.providers.remove(provider);
    }

    private void scheduleTask() {
        if (!this.taskState.compareAndSet(false, true)) {
            return;
        }
        this.mcSchedulerProvider.getAsyncScheduler().scheduleAtFixedRate(this::onTick, 2L, 2L);
    }

    public TaskResponse<Void> onTick() {
        try {
            this.tick();
        }
        catch (Exception ex) {
            Stacktrace.print(ex);
        }
        if (this.providers.isEmpty()) {
            this.taskState.set(false);
            return TaskResponse.success(null);
        }
        return TaskResponse.continueTask();
    }

    private void tick() {
        if (!Fairy.isRunning()) {
            return;
        }
        for (MCPlayer player : this.mcPlayerRegistry.getAllPlayers()) {
            Sidebar sidebar = this.get(player);
            if (sidebar == null) continue;
            sidebar.setTicks(sidebar.getTicks() + 1);
            if (sidebar.getTicks() < 10) continue;
            SidebarData data = this.writeProviderToData(player);
            if (data == null) {
                if (sidebar.getProvider() != null) {
                    sidebar.getProvider().onSidebarHidden(player, sidebar);
                }
                sidebar.remove();
                continue;
            }
            SidebarProvider provider = data.getProvider();
            if (!sidebar.isAvailable()) {
                provider.onSidebarShown(player, sidebar);
            }
            sidebar.setProvider(provider);
            sidebar.setTitle(data.getTitle());
            sidebar.setLines(data.getLines());
        }
    }

    private SidebarData writeProviderToData(MCPlayer player) {
        for (SidebarProvider provider : this.providers) {
            boolean shouldDisplay = provider.shouldDisplay(player);
            Component title = provider.getTitle(player);
            List<SidebarLine> lines = provider.getLines(player);
            if (!shouldDisplay || title == null || lines == null || lines.isEmpty()) continue;
            return new SidebarData(provider, title, lines);
        }
        return null;
    }

    public void remove(MCPlayer player) {
        Sidebar sidebar = this.get(player);
        if (sidebar == null) {
            return;
        }
        sidebar.remove();
        MCMetadata.providePlayer(player).remove(Sidebar.METADATA_TAG);
    }

    public Sidebar get(MCPlayer player) {
        return MCMetadata.providePlayer(player).getOrNull(Sidebar.METADATA_TAG);
    }

    public Sidebar getOrCreate(MCPlayer player) {
        return MCMetadata.providePlayer(player).computeIfAbsent(Sidebar.METADATA_TAG, () -> new Sidebar(player, this.sidebarHandler));
    }

    public SidebarService(ContainerContext containerContext, MCProtocol mcProtocol, MCPlayerRegistry mcPlayerRegistry, MCSchedulerProvider mcSchedulerProvider) {
        this.containerContext = containerContext;
        this.mcProtocol = mcProtocol;
        this.mcPlayerRegistry = mcPlayerRegistry;
        this.mcSchedulerProvider = mcSchedulerProvider;
    }

    private static class SidebarData {
        private final SidebarProvider provider;
        private final Component title;
        private final List<SidebarLine> lines;

        public SidebarData(SidebarProvider provider, Component title, List<SidebarLine> lines) {
            this.provider = provider;
            this.title = title;
            this.lines = lines;
        }

        public SidebarProvider getProvider() {
            return this.provider;
        }

        public Component getTitle() {
            return this.title;
        }

        public List<SidebarLine> getLines() {
            return this.lines;
        }
    }
}

