/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.thread;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public class BlockingThreadAwaitQueue
implements Executor {
    private final Queue<Runnable> runnableQueue = new ConcurrentLinkedQueue<Runnable>();
    private final Object lock = new Object();
    private boolean workingState = true;

    public static BlockingThreadAwaitQueue create() {
        return new BlockingThreadAwaitQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.workingState) {
                runnable.run();
                return;
            }
            this.runnableQueue.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(@NotNull BooleanSupplier booleanSupplier) {
        while (!booleanSupplier.getAsBoolean()) {
            Runnable runnable;
            Object object = this.lock;
            synchronized (object) {
                runnable = this.runnableQueue.poll();
            }
            if (runnable != null) {
                runnable.run();
            }
            Thread.yield();
        }
        Object object = this.lock;
        synchronized (object) {
            Runnable runnable;
            this.workingState = false;
            while ((runnable = this.runnableQueue.poll()) != null) {
                runnable.run();
            }
        }
    }
}

