/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.thread;

import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final int priority = 5;

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = new Thread(r, this.name);
        thread.setDaemon(this.daemon);
        thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        thread.setPriority(this.priority);
        return thread;
    }

    public static NamedThreadFactoryBuilder builder() {
        return new NamedThreadFactoryBuilder();
    }

    public NamedThreadFactory(String name, boolean daemon, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.name = name;
        this.daemon = daemon;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static class NamedThreadFactoryBuilder {
        private String name;
        private boolean daemon;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        NamedThreadFactoryBuilder() {
        }

        public NamedThreadFactoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NamedThreadFactoryBuilder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public NamedThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public NamedThreadFactory build() {
            return new NamedThreadFactory(this.name, this.daemon, this.uncaughtExceptionHandler);
        }

        public String toString() {
            return "NamedThreadFactory.NamedThreadFactoryBuilder(name=" + this.name + ", daemon=" + this.daemon + ", uncaughtExceptionHandler=" + this.uncaughtExceptionHandler + ")";
        }
    }
}

