/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject;

import io.fairyproject.log.Log;
import io.fairyproject.util.SimpleTiming;
import io.fairyproject.util.Stacktrace;

public final class Debug {
    public static boolean UNIT_TEST = false;
    public static boolean IN_FAIRY_IDE = Boolean.getBoolean("fairy.project-ide");
    public static boolean SHOW_LOGS = Boolean.getBoolean("fairy.showlog");
    public static boolean IN_DEV_IDE = false;
    public static Runnable BREAKPOINT;

    public static void log(String msg, Object ... replacement) {
        if (SHOW_LOGS) {
            Log.info(String.format(msg, replacement), new Object[0]);
        }
    }

    public static void warn(String msg, Object ... replacement) {
        if (SHOW_LOGS) {
            Log.warn(String.format(msg, replacement), new Object[0]);
        }
    }

    public static SimpleTiming logTiming(String msg) {
        return SimpleTiming.create(time -> Debug.log("Ended %s - took %d ms", msg, time));
    }

    public static void doPause() {
        if (!Debug.isInIde()) {
            return;
        }
        System.err.println("Pausing...");
        if (BREAKPOINT == null) {
            System.err.println("You don't seems to have breakpoint setup!");
        } else {
            BREAKPOINT.run();
        }
    }

    public static void logExceptionAndPause(Throwable throwable) {
        Stacktrace.print(throwable);
        Debug.doPause();
    }

    public static boolean isInIde() {
        return IN_FAIRY_IDE || IN_DEV_IDE;
    }

    private Debug() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

