/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject;

import io.fairyproject.Debug;
import io.fairyproject.PlatformType;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.library.LibraryHandler;
import io.fairyproject.library.LibraryHandlerImpl;
import io.fairyproject.library.LibraryHandlerNoOp;
import io.fairyproject.log.Log;
import io.fairyproject.metadata.CommonMetadataRegistries;
import io.fairyproject.plugin.Plugin;
import io.fairyproject.plugin.PluginManager;
import io.fairyproject.util.URLClassLoaderAccess;
import io.fairyproject.util.terminable.Terminable;
import io.fairyproject.util.terminable.TerminableConsumer;
import io.fairyproject.util.terminable.composite.CompositeClosingException;
import io.fairyproject.util.terminable.composite.CompositeTerminable;
import io.github.classgraph.ClassGraph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FairyPlatform
implements TerminableConsumer {
    public static FairyPlatform INSTANCE;
    private final AtomicBoolean loadedDependencies = new AtomicBoolean();
    private Plugin mainPlugin;
    private CompositeTerminable compositeTerminable;
    private LibraryHandler libraryHandler;
    private ContainerContext containerContext;

    public FairyPlatform() {
        ClassGraph.CIRCUMVENT_ENCAPSULATION = ClassGraph.CircumventEncapsulationMethod.JVM_DRIVER;
    }

    public void preload() {
        this.libraryHandler = Debug.UNIT_TEST ? new LibraryHandlerNoOp() : new LibraryHandlerImpl(this);
    }

    public void load(Plugin mainPlugin) {
        this.mainPlugin = mainPlugin;
        this.compositeTerminable = CompositeTerminable.create();
    }

    public void enable() {
        this.containerContext = new ContainerContext();
        this.containerContext.init();
    }

    public void disable() {
        try {
            this.compositeTerminable.close();
        }
        catch (CompositeClosingException ex) {
            ex.printStackTrace();
        }
        this.containerContext.stop();
        CommonMetadataRegistries.PLAYERS.destroy();
        PluginManager.INSTANCE.callFrameworkFullyDisable();
        INSTANCE = null;
    }

    @Override
    @NotNull
    public <T extends Terminable> T bind(T t) {
        return this.compositeTerminable.bind(t);
    }

    public abstract URLClassLoaderAccess getClassloader();

    public abstract File getDataFolder();

    public void onPostServicesInitial() {
    }

    @Nullable
    public String getClassLoaderName(ClassLoader classLoader) throws Exception {
        return null;
    }

    public void saveResource(String name, boolean replace) {
        block8: {
            if (name != null && !name.equals("")) {
                InputStream in = this.getResource(name = name.replace('\\', '/'));
                if (in == null) {
                    throw new IllegalArgumentException("The embedded resource '" + name + "' cannot be found");
                }
                File outFile = new File(this.getDataFolder(), name);
                int lastIndex = name.lastIndexOf(47);
                File outDir = new File(this.getDataFolder(), name.substring(0, Math.max(lastIndex, 0)));
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                try {
                    int len;
                    if (outFile.exists() && !replace) {
                        Log.warn("Could not save " + outFile.getName() + " to " + outFile + " because " + outFile.getName() + " already exists.", new Object[0]);
                        break block8;
                    }
                    FileOutputStream out = new FileOutputStream(outFile);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    in.close();
                }
                catch (IOException var10) {
                    Log.info("Could not save " + outFile.getName() + " to " + outFile, var10, new Object[0]);
                }
            } else {
                throw new IllegalArgumentException("ResourcePath cannot be null or empty");
            }
        }
    }

    public InputStream getResource(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException var4) {
            return null;
        }
    }

    public abstract void shutdown();

    public abstract boolean isRunning();

    public abstract PlatformType getPlatformType();

    public AtomicBoolean getLoadedDependencies() {
        return this.loadedDependencies;
    }

    public Plugin getMainPlugin() {
        return this.mainPlugin;
    }

    public CompositeTerminable getCompositeTerminable() {
        return this.compositeTerminable;
    }

    public LibraryHandler getLibraryHandler() {
        return this.libraryHandler;
    }

    public ContainerContext getContainerContext() {
        return this.containerContext;
    }
}

