/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.command;

import io.fairyproject.bukkit.command.map.BukkitCommandMap;
import io.fairyproject.command.BaseCommand;
import io.fairyproject.command.CommandListener;
import io.fairyproject.command.CommandService;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostDestroy;
import io.fairyproject.container.PreInitialize;

@InjectableComponent
public class BukkitCommandListener
implements CommandListener {
    private final CommandService commandService;
    private final BukkitCommandMap bukkitCommandMap;

    @PreInitialize
    public void init() {
        this.commandService.addCommandListener(this);
    }

    @PostDestroy
    public void destroy() {
        this.commandService.removeCommandListener(this);
    }

    @Override
    public void onCommandInitial(BaseCommand command, String[] aliases) {
        this.bukkitCommandMap.register(command);
    }

    @Override
    public void onCommandRemoval(BaseCommand command) {
        this.bukkitCommandMap.unregister(command);
    }

    public BukkitCommandListener(CommandService commandService, BukkitCommandMap bukkitCommandMap) {
        this.commandService = commandService;
        this.bukkitCommandMap = bukkitCommandMap;
    }
}

