/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.command.map;

import io.fairyproject.bukkit.command.BukkitCommandExecutor;
import io.fairyproject.bukkit.command.map.BukkitCommandMap;
import io.fairyproject.bukkit.command.sync.SyncCommandHandler;
import io.fairyproject.command.BaseCommand;
import io.fairyproject.data.MetaKey;
import io.fairyproject.data.MetaStorage;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

public class DefaultBukkitCommandMap
implements BukkitCommandMap {
    public static final MetaKey<BukkitCommandExecutor> EXECUTOR_KEY = MetaKey.create("fairy:command-executor", BukkitCommandExecutor.class);
    private final CommandMap commandMap;
    private final Map<String, Command> knownCommands;
    private final SyncCommandHandler syncCommandHandler;

    @Override
    public void register(BaseCommand command) {
        if (this.isRegistered(command)) {
            throw new IllegalArgumentException("Command already registered");
        }
        String[] commandNames = command.getCommandNames();
        BukkitCommandExecutor commandExecutor = new BukkitCommandExecutor(command, commandNames);
        String fallbackPrefix = commandExecutor.getFallbackPrefix();
        for (String name : commandNames) {
            if (!this.isCommandNameRegistered(name, fallbackPrefix)) continue;
            throw new IllegalArgumentException(String.format("Command with name %s already registered", name));
        }
        command.getMetaStorage().put(EXECUTOR_KEY, commandExecutor);
        this.commandMap.register(fallbackPrefix, (Command)commandExecutor);
        this.syncCommandHandler.sync();
    }

    @Override
    public void unregister(BaseCommand command) {
        MetaStorage metaStorage = command.getMetaStorage();
        if (!this.isRegistered(command)) {
            throw new IllegalArgumentException("Command not registered");
        }
        metaStorage.ifPresent(EXECUTOR_KEY, commandExecutor -> {
            String fallbackPrefix = commandExecutor.getFallbackPrefix();
            this.unregisterKnownCommand(fallbackPrefix, commandExecutor.getName());
            for (String alias : commandExecutor.getAliases()) {
                this.unregisterKnownCommand(fallbackPrefix, alias);
            }
            commandExecutor.unregister(this.commandMap);
            metaStorage.remove(EXECUTOR_KEY);
        });
        this.syncCommandHandler.sync();
    }

    private boolean isCommandNameRegistered(String name, String fallbackPrefix) {
        return this.knownCommands.containsKey(name) && this.knownCommands.containsKey(fallbackPrefix + ":" + name);
    }

    @Override
    public boolean isRegistered(BaseCommand command) {
        return command.getMetaStorage().contains(EXECUTOR_KEY);
    }

    private void unregisterKnownCommand(String fallbackPrefix, String alias) {
        this.knownCommands.remove(fallbackPrefix + ":" + alias);
        this.knownCommands.remove(alias);
    }

    public DefaultBukkitCommandMap(CommandMap commandMap, Map<String, Command> knownCommands, SyncCommandHandler syncCommandHandler) {
        this.commandMap = commandMap;
        this.knownCommands = knownCommands;
        this.syncCommandHandler = syncCommandHandler;
    }
}

