/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.command.parameters;

import io.fairyproject.bukkit.command.parameters.BukkitArgTransformer;
import io.fairyproject.container.InjectableComponent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@InjectableComponent
public class PlayerParameterTransformer
extends BukkitArgTransformer<Player> {
    @Override
    public Player transform(CommandSender sender, String source) {
        if (sender instanceof Player && (source.equalsIgnoreCase("self") || source.isEmpty())) {
            return (Player)sender;
        }
        Player player = Bukkit.getServer().getPlayer(source);
        if (player == null) {
            return (Player)this.fail("No player with the name " + source + " found.");
        }
        return player;
    }

    @Override
    public List<String> tabComplete(Player sender, String source) {
        ArrayList<String> completions = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)player.getName(), (CharSequence)source)) continue;
            completions.add(player.getName());
        }
        return completions;
    }

    @Override
    public Class[] type() {
        return new Class[]{Player.class};
    }
}

