/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.command.parameters;

import io.fairyproject.bukkit.command.parameters.BukkitArgTransformer;
import io.fairyproject.container.InjectableComponent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@InjectableComponent
public class WorldParameterTransformer
extends BukkitArgTransformer<World> {
    @Override
    public World transform(CommandSender sender, String source) {
        World world = Bukkit.getServer().getWorld(source);
        if (world == null) {
            return (World)this.fail("No world with the name " + source + " found.");
        }
        return world;
    }

    @Override
    public List<String> tabComplete(Player sender, String source) {
        ArrayList<String> completions = new ArrayList<String>();
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)world.getName(), (CharSequence)source)) continue;
            completions.add(world.getName());
        }
        return completions;
    }

    @Override
    public Class[] type() {
        return new Class[]{World.class};
    }
}

