/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.events;

import io.fairyproject.bukkit.events.handler.HandlerListCollection;
import io.fairyproject.bukkit.listener.RegisterAsListener;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.log.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

@InjectableComponent
@RegisterAsListener
public class GlobalEventListener
implements Listener {
    private final List<Consumer<Event>> listeners = new ArrayList<Consumer<Event>>();

    @PostInitialize
    public void onPostInitialize() {
        block5: {
            Log.info("Attempting to inject global event listeners...", new Object[0]);
            try {
                HandlerListCollection collection = new HandlerListCollection(HandlerList.getHandlerLists(), this);
                Field allLists = HandlerList.class.getDeclaredField("allLists");
                if (Modifier.isFinal(allLists.getModifiers())) {
                    Class<?> unsafeClass;
                    try {
                        unsafeClass = Class.forName("sun.misc.Unsafe");
                    }
                    catch (ClassNotFoundException e) {
                        unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                    }
                    Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Object unsafe = unsafeField.get(null);
                    Method staticFieldBaseMethod = unsafeClass.getDeclaredMethod("staticFieldBase", Field.class);
                    Method staticFieldOffsetMethod = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
                    Method putObjectMethod = unsafeClass.getDeclaredMethod("putObject", Object.class, Long.TYPE, Object.class);
                    Object staticFieldBase = staticFieldBaseMethod.invoke(unsafe, allLists);
                    long staticFieldOffset = (Long)staticFieldOffsetMethod.invoke(unsafe, allLists);
                    putObjectMethod.invoke(unsafe, staticFieldBase, staticFieldOffset, collection);
                    break block5;
                }
                allLists.setAccessible(true);
                allLists.set(null, collection);
            }
            catch (Throwable throwable) {
                Log.error("Failed to inject global event listeners, some features may not work properly. (are you using a JDK?)", throwable, new Object[0]);
                throwable.printStackTrace();
                return;
            }
        }
        Log.info("Successfully injected global event listeners.", new Object[0]);
    }

    public void addListener(Consumer<Event> listener) {
        this.listeners.add(listener);
    }

    public void onEventFired(Event event) {
        for (Consumer<Event> listener : this.listeners) {
            listener.accept(event);
        }
    }
}

