/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.mc.entity;

import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.MinecraftReflection;
import io.fairyproject.bukkit.reflection.resolver.ConstructorResolver;
import io.fairyproject.bukkit.reflection.resolver.FieldResolver;
import io.fairyproject.bukkit.reflection.resolver.MethodResolver;
import io.fairyproject.bukkit.reflection.resolver.ResolverQuery;
import io.fairyproject.bukkit.reflection.wrapper.ConstructorWrapper;
import io.fairyproject.bukkit.reflection.wrapper.FieldWrapper;
import io.fairyproject.bukkit.reflection.wrapper.MethodWrapper;
import io.fairyproject.libs.packetevents.PacketEvents;
import io.fairyproject.libs.packetevents.protocol.entity.data.EntityData;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import io.fairyproject.util.AccessUtil;
import io.fairyproject.util.exceptionally.ThrowingFunction;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BukkitDataWatcherConverter {
    private final BukkitNMSManager bukkitNMSManager;
    private Function<Entity, List<EntityData<?>>> converter;

    public Class<?> getPacketDataSerializerClass() throws ClassNotFoundException {
        return this.bukkitNMSManager.getNmsClassResolver().resolve("network.PacketDataSerializer", "network.FriendlyByteBuf", "PacketDataSerializer");
    }

    public Class<?> getEntityClass() throws ClassNotFoundException {
        return this.bukkitNMSManager.getNmsClassResolver().resolve("world.entity.Entity", "Entity");
    }

    public Class<?> getDataWatcherClass() throws ClassNotFoundException {
        return this.bukkitNMSManager.getNmsClassResolver().resolve("network.syncher.DataWatcher", "network.syncher.SynchedEntityData", "DataWatcher");
    }

    @NotNull
    public List<EntityData<?>> convert(@NotNull Entity entity) throws ReflectiveOperationException {
        if (this.converter == null) {
            Class<?> entityClass = this.getEntityClass();
            Class<?> dataWatcherClass = this.getDataWatcherClass();
            Class<?> packetDataSerializerClass = this.getPacketDataSerializerClass();
            Class<?> byteBufClass = Class.forName("io.netty.buffer.ByteBuf");
            Field field = new FieldResolver(entityClass).resolveByFirstType(dataWatcherClass);
            AccessUtil.setAccessible(field);
            FieldWrapper dataWatcherField = new FieldWrapper(field);
            ConstructorWrapper packetDataSerializerConstructor = new ConstructorResolver(packetDataSerializerClass).resolveWrapper(new Class[][]{{byteBufClass}});
            try {
                this.findConverterPre1_13(dataWatcherClass, packetDataSerializerClass, dataWatcherField, packetDataSerializerConstructor);
            }
            catch (Throwable throwable) {
                Method dataWatcherPackDirtyMethod = new MethodResolver(dataWatcherClass).resolve(new ResolverQuery(List.class, 0).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyDynamic(true).build()));
                this.findConverterModern(dataWatcherClass, packetDataSerializerClass, dataWatcherField, packetDataSerializerConstructor, dataWatcherPackDirtyMethod);
            }
        }
        return this.converter.apply(entity);
    }

    private void findConverterModern(Class<?> dataWatcherClass, Class<?> packetDataSerializerClass, FieldWrapper<?> dataWatcherField, ConstructorWrapper<?> packetDataSerializerConstructor, Method dataWatcherPackDirtyMethod) throws NoSuchMethodException {
        Method dataWatcherPackMethod;
        try {
            dataWatcherPackMethod = new MethodResolver(dataWatcherClass).resolve(new ResolverQuery(Void.TYPE, 0, List.class, packetDataSerializerClass).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyStatic(true).build()));
        }
        catch (Throwable throwable) {
            try {
                Class<?> packetClass = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata");
                dataWatcherPackMethod = new MethodResolver(packetClass).resolve(new ResolverQuery(Void.TYPE, 0, List.class, packetDataSerializerClass).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyStatic(true).build()));
            }
            catch (Throwable t) {
                throw new NoSuchMethodException("DataWatcher.pack(List, PacketDataSerializer) method not found");
            }
        }
        Method finalDataWatcherPackMethod = dataWatcherPackMethod;
        this.converter = ThrowingFunction.sneaky(e -> {
            Object handle = MinecraftReflection.getHandle(e);
            Object dataWatcher = dataWatcherField.get(handle);
            Object byteBuf = PacketEvents.getAPI().getNettyManager().getByteBufAllocationOperator().buffer();
            Object packetDataSerializer = packetDataSerializerConstructor.newInstance(byteBuf);
            Object dataItemList = dataWatcherPackDirtyMethod.invoke(dataWatcher, new Object[0]);
            finalDataWatcherPackMethod.invoke(null, dataItemList, packetDataSerializer);
            PacketWrapper<?> packetWrapper = PacketWrapper.createUniversalPacketWrapper(byteBuf);
            return packetWrapper.readEntityMetadata();
        });
    }

    private void findConverterPre1_13(Class<?> dataWatcherClass, Class<?> packetDataSerializerClass, FieldWrapper<?> dataWatcherField, ConstructorWrapper<?> packetDataSerializerConstructor) throws ReflectiveOperationException {
        MethodWrapper dataWatcherWriteMethod = new MethodResolver(dataWatcherClass).resolve(Void.TYPE, 0, packetDataSerializerClass);
        this.converter = ThrowingFunction.sneaky(e -> {
            Object handle = MinecraftReflection.getHandle(e);
            Object dataWatcher = dataWatcherField.get(handle);
            Object byteBuf = PacketEvents.getAPI().getNettyManager().getByteBufAllocationOperator().buffer();
            Object packetDataSerializer = packetDataSerializerConstructor.newInstance(byteBuf);
            dataWatcherWriteMethod.invoke(dataWatcher, packetDataSerializer);
            PacketWrapper<?> packetWrapper = PacketWrapper.createUniversalPacketWrapper(byteBuf);
            return packetWrapper.readEntityMetadata();
        });
    }

    public BukkitDataWatcherConverter(BukkitNMSManager bukkitNMSManager) {
        this.bukkitNMSManager = bukkitNMSManager;
    }
}

