/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.mc.entity;

import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.resolver.FieldResolver;
import io.fairyproject.bukkit.reflection.resolver.ResolverQuery;
import io.fairyproject.bukkit.reflection.wrapper.FieldWrapper;
import io.fairyproject.mc.entity.EntityIDCounter;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class BukkitEntityIDCounter
implements EntityIDCounter {
    private final BukkitNMSManager nmsManager;
    private Function<Integer, Integer> next;

    public BukkitEntityIDCounter(BukkitNMSManager nmsManager) {
        this.nmsManager = nmsManager;
    }

    @Override
    public int next() {
        if (this.next == null) {
            Function<Integer, Integer> function;
            Class<?> entityClass = this.nmsManager.getNmsClassResolver().resolveSilent("world.entity.Entity", "Entity");
            try {
                FieldWrapper fieldWrapper = new FieldResolver(entityClass).resolveWrapper("entityCount");
                if (fieldWrapper.getField().getType() != Integer.TYPE) {
                    throw new IllegalStateException("entityCount field is not an int!");
                }
                function = n -> {
                    int id = (Integer)fieldWrapper.get(null);
                    fieldWrapper.set(null, id + n);
                    return id;
                };
            }
            catch (Throwable throwable) {
                AtomicInteger entityCounter = null;
                try {
                    Field field = new FieldResolver(entityClass).resolve(new ResolverQuery(AtomicInteger.class, 0).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyStatic(true).onlyFinal(true).build()));
                    try {
                        entityCounter = (AtomicInteger)field.get(null);
                    }
                    catch (IllegalAccessException | InternalError ex) {
                        throw new IllegalStateException("Couldn't get the entity counter field!", ex);
                    }
                }
                catch (ReflectiveOperationException e) {
                    SneakyThrowUtil.sneakyThrow(e);
                }
                function = entityCounter::addAndGet;
            }
            this.next = function;
        }
        return this.next.apply(1);
    }
}

