/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.mc.impl;

import io.fairyproject.bukkit.mc.EntityUUIDFinder;
import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.MinecraftReflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;

public class EntityUUIDFinderImpl
implements EntityUUIDFinder {
    private final BukkitNMSManager nmsManager;
    private Function<UUID, Entity> uuidToEntity;

    @Override
    public Entity findEntityByUuid(UUID entityUuid) {
        if (this.uuidToEntity == null) {
            Function<UUID, Entity> uuidToEntity;
            try {
                Bukkit.class.getDeclaredMethod("getEntity", UUID.class);
                uuidToEntity = Bukkit::getEntity;
            }
            catch (NoSuchMethodException ex) {
                try {
                    Class minecraftServer = this.nmsManager.getNmsClassResolver().resolve("server.MinecraftServer", "MinecraftServer");
                    Object server = minecraftServer.getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
                    Method method = minecraftServer.getDeclaredMethod("a", UUID.class);
                    MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
                    uuidToEntity = uuid -> {
                        try {
                            return MinecraftReflection.getBukkitEntity(methodHandle.invoke(server, (UUID)uuid));
                        }
                        catch (Throwable throwable) {
                            throw new IllegalStateException(throwable);
                        }
                    };
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException(throwable);
                }
            }
            this.uuidToEntity = uuidToEntity;
        }
        return this.uuidToEntity.apply(entityUuid);
    }

    public EntityUUIDFinderImpl(BukkitNMSManager nmsManager) {
        this.nmsManager = nmsManager;
    }
}

